/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SetOilFunction
extends LootItemConditionalFunction {
    private final IOil oil;
    private final boolean random;

    SetOilFunction(LootItemCondition[] conditions, IOil oil, boolean random) {
        super(conditions);
        this.oil = oil;
        this.random = random;
    }

    @NotNull
    protected ItemStack m_7372_(@NotNull ItemStack pStack, @NotNull LootContext pContext) {
        IOil oil = this.oil;
        if (this.random) {
            Collection values = ModRegistries.OILS.get().getValues();
            oil = (IOil)values.stream().skip((int)((double)values.size() * pContext.m_230907_().m_188500_())).findFirst().orElseThrow(() -> new IllegalStateException("No oils registered"));
        }
        OilUtils.setOil(pStack, oil);
        return pStack;
    }

    public static LootItemConditionalFunction.Builder<?> setOil(IOil oil) {
        return SetOilFunction.m_80683_(conditions -> new SetOilFunction((LootItemCondition[])conditions, oil, false));
    }

    public static LootItemConditionalFunction.Builder<?> random() {
        return SetOilFunction.m_80683_(conditions -> new SetOilFunction((LootItemCondition[])conditions, null, true));
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLoot.SET_OIL.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetOilFunction> {
        public void serialize(@NotNull JsonObject pJson, @NotNull SetOilFunction pValue, @NotNull JsonSerializationContext pSerializationContext) {
            super.m_6170_(pJson, (LootItemConditionalFunction)pValue, pSerializationContext);
            if (pValue.random) {
                pJson.addProperty("random", Boolean.valueOf(true));
            } else if (pValue.oil != null) {
                pJson.addProperty("id", ModRegistries.OILS.get().getKey((Object)pValue.oil).toString());
            } else {
                throw new IllegalStateException("Either random or oil must be set");
            }
        }

        @NotNull
        public SetOilFunction deserialize(@NotNull JsonObject pObject, @NotNull JsonDeserializationContext pDeserializationContext, LootItemCondition @NotNull [] pConditions) {
            if (pObject.has("random") && GsonHelper.m_13912_((JsonObject)pObject, (String)"random")) {
                return new SetOilFunction(pConditions, null, true);
            }
            if (pObject.has("id")) {
                String id = GsonHelper.m_13906_((JsonObject)pObject, (String)"id");
                IOil oil = (IOil)ModRegistries.OILS.get().getValue(ResourceLocation.m_135820_((String)id));
                if (oil == null) {
                    throw new JsonSyntaxException("Unknown oil " + id);
                }
                return new SetOilFunction(pConditions, oil, false);
            }
            throw new JsonSyntaxException("Either random or oil must be set");
        }
    }
}

