/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionWorldData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ID = "vampirism-minion-data";
    private final MinecraftServer server;
    private final Object2ObjectOpenHashMap<UUID, PlayerMinionController> controllers = new Object2ObjectOpenHashMap();

    @NotNull
    public static MinionWorldData getData(@NotNull ServerLevel world) {
        return MinionWorldData.getData(world.m_7654_());
    }

    @NotNull
    public static MinionWorldData getData(@NotNull MinecraftServer server) {
        return (MinionWorldData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(data -> MinionWorldData.load(server, data), () -> new MinionWorldData(server), ID);
    }

    @NotNull
    public static Optional<MinionWorldData> getData(Level world) {
        if (world instanceof ServerLevel) {
            return Optional.of(MinionWorldData.getData(((ServerLevel)world).m_7654_()));
        }
        return Optional.empty();
    }

    public MinionWorldData(MinecraftServer server) {
        this.server = server;
    }

    @Nullable
    public PlayerMinionController getController(UUID lordID) {
        return (PlayerMinionController)this.controllers.get((Object)lordID);
    }

    @NotNull
    public PlayerMinionController getOrCreateController(@NotNull FactionPlayerHandler lord) {
        UUID id = lord.getPlayer().m_20148_();
        if (this.controllers.containsKey((Object)id)) {
            return (PlayerMinionController)this.controllers.get((Object)id);
        }
        PlayerMinionController c = new PlayerMinionController(this.server, id);
        c.setMaxMinions(lord.getCurrentFaction(), lord.getMaxMinions());
        this.controllers.put((Object)id, (Object)c);
        return c;
    }

    public boolean m_77764_() {
        return true;
    }

    @VisibleForDebug
    public void purgeController(UUID lordID) {
        this.controllers.remove((Object)lordID);
    }

    @NotNull
    public static MinionWorldData load(@NotNull MinecraftServer server, @NotNull CompoundTag nbt) {
        MinionWorldData data = new MinionWorldData(server);
        ListTag all = nbt.m_128437_("controllers", 10);
        for (Tag inbt : all) {
            CompoundTag tag = (CompoundTag)inbt;
            UUID id = tag.m_128342_("uuid");
            PlayerMinionController c = new PlayerMinionController(server, id);
            c.deserializeNBT(tag);
            data.controllers.put((Object)id, (Object)c);
        }
        return data;
    }

    public void tick() {
        this.controllers.object2ObjectEntrySet().fastForEach(entry -> ((PlayerMinionController)entry.getValue()).tick());
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag all = new ListTag();
        this.controllers.object2ObjectEntrySet().fastForEach(entry -> {
            if (((PlayerMinionController)entry.getValue()).hasMinions()) {
                CompoundTag tag = ((PlayerMinionController)entry.getValue()).serializeNBT();
                tag.m_128362_("uuid", (UUID)entry.getKey());
                all.add((Object)tag);
            }
        });
        compound.m_128365_("controllers", (Tag)all);
        return compound;
    }

    public Map<UUID, PlayerMinionController> getControllers() {
        return Collections.unmodifiableMap(this.controllers);
    }
}

