/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record GenericParticleOptions(ResourceLocation texture, int maxAge, int color, float speed) implements ParticleOptions
{
    public static final Codec<GenericParticleOptions> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.STRING.fieldOf("t").forGetter(p_239807_0_ -> p_239807_0_.texture.toString()), (App)Codec.INT.fieldOf("a").forGetter(p_239806_0_ -> p_239806_0_.maxAge), (App)Codec.INT.fieldOf("c").forGetter(p_239805_0_ -> p_239805_0_.color), (App)Codec.FLOAT.fieldOf("s").forGetter(p_239804_0_ -> Float.valueOf(p_239804_0_.speed))).apply((Applicative)p_239803_0_, (t, a, c, s) -> new GenericParticleOptions(new ResourceLocation(t), (int)a, (int)c, s.floatValue())));
    public static final ParticleOptions.Deserializer<GenericParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<GenericParticleOptions>(){

        @NotNull
        public GenericParticleOptions fromCommand(@NotNull ParticleType<GenericParticleOptions> particleTypeIn, @NotNull StringReader reader) throws CommandSyntaxException {
            return new GenericParticleOptions(ResourceLocation.m_135818_((StringReader)reader), reader.readInt(), reader.readInt());
        }

        @NotNull
        public GenericParticleOptions fromNetwork(@NotNull ParticleType<GenericParticleOptions> particleTypeIn, @NotNull FriendlyByteBuf buffer) {
            return new GenericParticleOptions(buffer.m_130281_(), buffer.m_130242_(), buffer.m_130242_(), buffer.readFloat());
        }
    };

    public GenericParticleOptions(ResourceLocation texture, int maxAge, int color) {
        this(texture, maxAge, color, 1.0f);
    }

    public void m_7711_(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(this.texture);
        packetBuffer.m_130130_(this.maxAge);
        packetBuffer.m_130130_(this.color);
        packetBuffer.writeFloat(this.speed);
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.GENERIC.get();
    }

    @NotNull
    public String m_5942_() {
        return String.valueOf(ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_())) + " " + String.valueOf(this.texture) + " " + this.maxAge + " " + this.color;
    }
}

