/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class HalfInvulnerableAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public int getCooldown(IVampirePlayer player) {
        return 20 * (Integer)VampirismConfig.BALANCE.vaHalfInvulnerableCooldown.get();
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        return 20 * (Integer)VampirismConfig.BALANCE.vaHalfInvulnerableDuration.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaHalfInvulnerableEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer player) {
    }

    @Override
    public void onDeactivated(@NotNull IVampirePlayer player) {
        ((VampirePlayer)player).getSpecialAttributes().half_invulnerable = false;
        this.removePotionEffect(player, MobEffects.f_19597_);
    }

    @Override
    public void onReActivated(@NotNull IVampirePlayer player) {
        ((VampirePlayer)player).getSpecialAttributes().half_invulnerable = true;
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.isRemote() && vampire.getRepresentingPlayer().f_19797_ % 20 == 0) {
            this.applyEffect(vampire);
        }
        return false;
    }

    @Override
    protected boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        ((VampirePlayer)vampire).getSpecialAttributes().half_invulnerable = true;
        this.applyEffect(vampire);
        return true;
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }

    @Override
    public boolean showHudDuration(Player player) {
        return true;
    }

    protected void applyEffect(IVampirePlayer vampire) {
        this.addEffectInstance(vampire, new MobEffectInstance(MobEffects.f_19597_, 22, 1, false, false));
    }
}

