/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.reward;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.player.refinements.RefinementSet;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefinementItemReward
extends ItemReward {
    public static final Codec<RefinementItemReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("item").forGetter(i -> Optional.ofNullable(i.item.get()).map(ItemLike::m_5456_)), (App)IFaction.CODEC.optionalFieldOf("faction").forGetter(i -> Optional.ofNullable(i.faction)), (App)StringRepresentable.m_216439_(IRefinementSet.Rarity::values).optionalFieldOf("rarity").forGetter(i -> Optional.ofNullable(i.rarity))).apply((Applicative)inst, (reward, faction, rarity) -> {
        Preconditions.checkArgument((reward.isEmpty() || reward.get() instanceof IRefinementItem ? 1 : 0) != 0, (Object)"Item must be a refinement item");
        Preconditions.checkArgument((reward.isEmpty() || RefinementItemReward.matchFaction(((IRefinementItem)reward.get()).getExclusiveFaction(((Item)reward.get()).m_7968_()), (IFaction)faction.get()) ? 1 : 0) != 0, (Object)"Faction must match item faction");
        return new RefinementItemReward(reward.orElse(null), faction.orElse(null), (IRefinementSet.Rarity)rarity.orElse(null));
    }));
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final @NotNull Supplier<@Nullable IRefinementItem> item;
    @Nullable
    private final IFaction<?> faction;
    @Nullable
    private final IRefinementSet.Rarity rarity;

    public RefinementItemReward(@Nullable IFaction<?> faction) {
        this(faction, null);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @Nullable IRefinementSet.Rarity refinementRarity) {
        this(faction, () -> null, refinementRarity);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @NotNull Supplier<@Nullable IRefinementItem> item, @Nullable IRefinementSet.Rarity refinementRarity) {
        super(ItemStack.f_41583_);
        this.item = item;
        this.faction = faction;
        this.rarity = refinementRarity;
    }

    private RefinementItemReward(@Nullable IRefinementItem reward, @Nullable IFaction<?> faction, @Nullable IRefinementSet.Rarity rarity) {
        super(ItemStack.f_41583_);
        this.item = () -> reward;
        this.faction = faction;
        this.rarity = rarity;
    }

    @Override
    @NotNull
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return new ItemReward.Instance(this.createItem());
    }

    @Override
    public List<ItemStack> getAllPossibleRewards() {
        return !this.reward.m_41619_() ? Collections.singletonList(new ItemStack((ItemLike)this.reward.m_41720_())) : this.getAllRefinementItems();
    }

    @NotNull
    protected <Z extends Item> ItemStack createItem() {
        if (this.faction != null && !(this.faction instanceof IPlayableFaction)) {
            return ItemStack.f_41583_;
        }
        IPlayableFaction faction = (IPlayableFaction)this.faction;
        IRefinementItem baseItem = this.item.get();
        if (faction == null && (faction = baseItem != null ? (IPlayableFaction)baseItem.getExclusiveFaction(baseItem.m_5456_().m_7968_()) : RefinementItemReward.getRandomFactionWithAccessories()) == null) {
            return ItemStack.f_41583_;
        }
        IPlayableFaction finalFaction = faction;
        Item item = this.item.get() != null ? (Item)this.item.get() : faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[RANDOM.m_188503_(IRefinementItem.AccessorySlotType.values().length)]);
        IRefinementItem.AccessorySlotType slot = ((IRefinementItem)item).getSlotType();
        List sets = RegUtil.values(ModRegistries.REFINEMENT_SETS).stream().filter(set -> set.getFaction() == finalFaction).filter(set -> this.rarity == null || set.getRarity().ordinal() >= this.rarity.ordinal()).filter(set -> set.getSlotType().map(slot1 -> slot1 == slot).orElse(true)).map(set -> ((RefinementSet)set).getWeightedRandom()).collect(Collectors.toList());
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!sets.isEmpty()) {
            WeightedRandom.m_216822_((RandomSource)RANDOM, sets).map(WeightedEntry.Wrapper::m_146310_).ifPresent(set -> ((IRefinementItem)item).applyRefinementSet(stack, (IRefinementSet)set));
        }
        return stack;
    }

    @NotNull
    private List<ItemStack> getAllRefinementItems() {
        IPlayableFaction<?>[] iPlayableFactionArray;
        if (this.faction != null) {
            IPlayableFaction[] iPlayableFactionArray2 = new IPlayableFaction[1];
            iPlayableFactionArray = iPlayableFactionArray2;
            iPlayableFactionArray2[0] = (IPlayableFaction)this.faction;
        } else {
            iPlayableFactionArray = VampirismAPI.factionRegistry().getPlayableFactions();
        }
        return Arrays.stream(iPlayableFactionArray).filter(IPlayableFaction::hasRefinements).flatMap(function -> Arrays.stream(IRefinementItem.AccessorySlotType.values()).map(function::getRefinementItem)).map(a -> new ItemStack((ItemLike)a)).collect(Collectors.toList());
    }

    @Nullable
    private static IPlayableFaction<?> getRandomFactionWithAccessories() {
        List<IPlayableFaction> factions = Arrays.stream(VampirismAPI.factionRegistry().getPlayableFactions()).filter(IPlayableFaction::hasRefinements).toList();
        if (factions.isEmpty()) {
            return null;
        }
        return factions.get(RANDOM.m_188503_(factions.size()) - 1);
    }

    @Override
    public Codec<? extends TaskReward> codec() {
        return CODEC;
    }

    private static boolean matchFaction(IFaction<?> target, IFaction<?> faction) {
        return target == null || faction == null || target == faction;
    }
}

