/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.data.recipebuilder.FinishedSkillNode;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SkillNodeBuilder {
    @NotNull
    private final ResourceLocation parent;
    private final ISkill<?>[] skills;
    private ResourceLocation faction;
    private ResourceLocation[] lockingSkillNodes;

    @NotNull
    public static SkillNodeBuilder skill(@NotNull ResourceLocation parent, ISkill<?> ... skills) {
        return new SkillNodeBuilder(parent, skills);
    }

    public static SkillNodeBuilder hunter(@NotNull ResourceLocation parent, ISkill<?> ... skills) {
        SkillNodeBuilder.assertFactionSkills(VReference.HUNTER_FACTION, skills);
        return SkillNodeBuilder.skill(parent, skills).faction(VReference.HUNTER_FACTION);
    }

    public static SkillNodeBuilder vampire(@NotNull ResourceLocation parent, ISkill<?> ... skills) {
        SkillNodeBuilder.assertFactionSkills(VReference.VAMPIRE_FACTION, skills);
        return SkillNodeBuilder.skill(parent, skills).faction(VReference.VAMPIRE_FACTION);
    }

    public static void assertFactionSkills(IPlayableFaction<?> faction, ISkill<?> ... skills) {
        if (Arrays.stream(skills).anyMatch(skill -> skill.getFaction().filter(f -> f != faction).isPresent())) {
            throw new IllegalArgumentException("Illegal skill for faction. Skills must be for the same or any faction");
        }
    }

    public SkillNodeBuilder(@NotNull ResourceLocation parent, ISkill<?> ... skills) {
        this.parent = parent;
        this.skills = skills;
        this.lockingSkillNodes = new ResourceLocation[0];
    }

    @NotNull
    public ResourceLocation build(@NotNull Consumer<FinishedSkillNode> consumer, @NotNull ResourceLocation id) {
        if (this.faction != null) {
            id = new ResourceLocation(id.m_135827_(), this.faction.m_135815_() + "/" + id.m_135815_());
        }
        this.validate(id);
        consumer.accept(new Result(id, this.parent, this.skills, this.lockingSkillNodes));
        return id;
    }

    @NotNull
    public SkillNodeBuilder faction(@NotNull IPlayableFaction<?> faction) {
        this.faction = faction.getID();
        return this;
    }

    @NotNull
    public SkillNodeBuilder lockingNodes(ResourceLocation ... skillNodes) {
        this.lockingSkillNodes = skillNodes;
        return this;
    }

    private void validate(@NotNull ResourceLocation id) {
        if (this.skills.length == 0) {
            throw new IllegalStateException("No skills defined for skill node " + String.valueOf(id) + "!");
        }
    }

    private static class Result
    implements FinishedSkillNode {
        @NotNull
        private final ResourceLocation parent;
        private final ISkill<?>[] skills;
        @NotNull
        private final ResourceLocation id;
        private final ResourceLocation[] lockingSkillNodes;

        public Result(@NotNull ResourceLocation id, @NotNull ResourceLocation parent, @NotNull ISkill<?>[] skills, @NotNull ResourceLocation[] lockingSkillNodes) {
            this.id = id;
            this.parent = parent;
            this.skills = skills;
            this.lockingSkillNodes = lockingSkillNodes;
        }

        @Override
        @NotNull
        public ResourceLocation getID() {
            return this.id;
        }

        @Override
        public void serialize(@NotNull JsonObject json) {
            json.addProperty("parent", this.parent.toString());
            JsonArray array = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                array.add(RegUtil.id(skill).toString());
            }
            json.add("skills", (JsonElement)array);
            if (this.lockingSkillNodes.length > 0) {
                JsonArray nodes = new JsonArray();
                for (ResourceLocation lockingSkillNode : this.lockingSkillNodes) {
                    nodes.add(lockingSkillNode.toString());
                }
                json.add("locking", (JsonElement)nodes);
            }
        }
    }
}

