/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.teamlapen.vampirism.blockentity.AltarInfusionBlockEntity;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AltarInfusionBESR
extends VampirismBESR<AltarInfusionBlockEntity> {
    private final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("vampirism", "textures/entity/infusion_beam.png");
    private final ResourceLocation beaconBeamTexture = new ResourceLocation("textures/entity/beacon_beam.png");

    public AltarInfusionBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull AltarInfusionBlockEntity te, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int combinedLight, int combinedOverlay) {
        AltarInfusionBlockEntity.PHASE phase = te.getCurrentPhase();
        if (phase == AltarInfusionBlockEntity.PHASE.BEAM1 || phase == AltarInfusionBlockEntity.PHASE.BEAM2) {
            Player p;
            BlockPos[] tips;
            float cX = (float)te.m_58899_().m_123341_() + 0.5f;
            float cY = (float)te.m_58899_().m_123342_() + 3.0f;
            float cZ = (float)te.m_58899_().m_123343_() + 0.5f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 3.0, 0.5);
            for (BlockPos tip : tips = te.getTips()) {
                this.renderBeam(matrixStack, iRenderTypeBuffer, -((float)te.getRunningTick() + partialTicks), (float)tip.m_123341_() + 0.5f - cX, (float)tip.m_123342_() + 0.5f - cY, (float)tip.m_123343_() + 0.5f - cZ, combinedLight, true);
            }
            if (phase == AltarInfusionBlockEntity.PHASE.BEAM2 && (p = te.getPlayer()) != null) {
                this.renderBeam(matrixStack, iRenderTypeBuffer, -((float)te.getRunningTick() + partialTicks), (float)p.m_20185_() - cX, (float)p.m_20186_() + 1.2f - cY, (float)p.m_20189_() - cZ, combinedLight, false);
            }
            matrixStack.m_85849_();
        }
    }

    private void renderBeam(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, float partialTicks, float dx, float dy, float dz, int packedLight, boolean beacon) {
        float distFlat = Mth.m_14116_((float)(dx * dx + dz * dz));
        float dist = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrixStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(distFlat, dy)) - 1.5707964f));
        VertexConsumer ivertexbuilder = renderTypeBuffer.m_6299_(RenderType.m_110476_((ResourceLocation)(beacon ? this.beaconBeamTexture : this.enderDragonCrystalBeamTextures)));
        float f2 = partialTicks * 0.05f;
        float f3 = dist / 32.0f + partialTicks * 0.05f;
        float f4 = 0.0f;
        float f5 = 0.2f;
        float f6 = 0.0f;
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.2f;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.2f;
            float f9 = (float)j / 8.0f;
            ivertexbuilder.m_252986_(matrix4f, f4, f5, 0.0f).m_6122_(75, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_252986_(matrix4f, f4 * 0.5f, f5 * 0.5f, dist).m_6122_(255, 0, 0, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_252986_(matrix4f, f7 * 0.5f, f8 * 0.5f, dist).m_6122_(255, 0, 0, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_252986_(matrix4f, f7, f8, 0.0f).m_6122_(75, 0, 0, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        matrixStack.m_85849_();
    }
}

