/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.util.ItemOrdering;
import de.teamlapen.vampirism.client.ClientConfigHelper;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen;
import de.teamlapen.vampirism.client.gui.screens.radial.edit.ReorderingGuiRadialMenu;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ServerboundActionBindingPacket;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSelectActionScreen<T extends IFactionPlayer<T>>
extends ReorderingGuiRadialMenu<IAction<?>> {
    private KeyBindingList keyBindingList;

    public static void show() {
        FactionPlayerHandler.getOpt((Player)Minecraft.m_91087_().f_91074_).map(FactionPlayerHandler::getCurrentFactionPlayer).flatMap(optional -> optional).ifPresent(factionPlayer -> Minecraft.m_91087_().m_91152_(new EditSelectActionScreen<IFactionPlayer>((IFactionPlayer)factionPlayer)));
    }

    private static void drawActionPart(@Nullable IAction<?> action, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        if (action == null) {
            return;
        }
        graphics.m_280398_(EditSelectActionScreen.getActionIcon(action), posX, posY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static ResourceLocation getActionIcon(IAction<?> action) {
        ResourceLocation id = RegUtil.id(action);
        return new ResourceLocation(id.m_135827_(), "textures/actions/" + id.m_135815_() + ".png");
    }

    private static <T extends IFactionPlayer<T>> boolean isEnabled(T player, @NotNull IAction<?> item) {
        return player.getActionHandler().isActionUnlocked(item);
    }

    private static <T extends IFactionPlayer<T>> ItemOrdering<IAction<?>> getOrdering(T player) {
        return new ItemOrdering(ClientConfigHelper.getActionOrder(player.getFaction()), new ArrayList(), () -> VampirismRegistries.ACTIONS.get().getValues().stream().filter(action -> action.matchesFaction((IPlayableFaction<?>)player.getFaction())).collect(Collectors.toList()));
    }

    private static <T extends IFactionPlayer<T>> void saveOrdering(T player, ItemOrdering<IAction<?>> ordering) {
        ClientConfigHelper.saveActionOrder(player.getFaction().getID(), ordering.getOrdering());
    }

    public EditSelectActionScreen(T player) {
        super(EditSelectActionScreen.getOrdering(player), action -> action.getName().m_6879_(), EditSelectActionScreen::drawActionPart, ordering -> EditSelectActionScreen.saveOrdering(player, ordering), item -> EditSelectActionScreen.isEnabled(player, item));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.keyBindingList = (KeyBindingList)this.m_142416_((GuiEventListener)new KeyBindingList(this.f_96543_ - 140, 20, 140, this.f_96544_ - 60));
        this.m_142416_((GuiEventListener)new ReorderingGuiRadialMenu.ResetButton(this.f_96543_ - 140, this.f_96544_ - 40, 140, 20, context -> this.resetKeyBindings()));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ - 140, this.f_96544_ - 20, 140, 20, (Component)Component.m_237115_((String)"text.vampirism.open_settings"), context -> Minecraft.m_91087_().m_91152_((Screen)new KeyBindsScreen((Screen)this, this.getMinecraft().f_91066_))));
    }

    private void resetKeyBindings() {
        ModKeys.ACTION_KEYS.keySet().forEach(key -> {
            FactionPlayerHandler.getOpt((Player)this.getMinecraft().f_91074_).ifPresent(factionPlayerHandler -> factionPlayerHandler.setBoundAction((int)key, null, false, false));
            VampirismMod.dispatcher.sendToServer(new ServerboundActionBindingPacket((int)key, null));
        });
        this.keyBindingList.clearActions();
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        graphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        int i = 32;
        graphics.m_280398_(f_279548_, this.f_96543_ - 140, 0, 0, 0.0f, 0.0f, 140, this.f_96544_, i, i);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"text.vampirism.key_shortcuts"), this.f_96543_ - 70, 5, -1);
    }

    public class KeyBindingList
    extends ContainerObjectSelectionList<de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen$KeyBindingList.KeyBindingSetting> {
        public KeyBindingList(int x, int y, int pWidth, int pHeight) {
            super(Minecraft.m_91087_(), pWidth, pHeight, y, y + pHeight, 20);
            this.m_93488_(false);
            this.m_93507_(x);
            FactionPlayerHandler opt = FactionPlayerHandler.get((Player)Minecraft.m_91087_().f_91074_);
            this.m_5988_(ModKeys.ACTION_KEYS.entrySet().stream().map(pair -> new KeyBindingSetting((Integer)pair.getKey(), (KeyMapping)pair.getValue(), opt.getBoundAction((Integer)pair.getKey()))).sorted(Comparator.comparingInt(o -> o.index)).toList());
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }

        public Optional<GuiEventListener> m_94729_(double pMouseX, double pMouseY) {
            return super.m_94729_(pMouseX, pMouseY);
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public int m_5747_() {
            return super.m_5747_() - 2;
        }

        protected int m_7610_(int pIndex) {
            return super.m_7610_(pIndex);
        }

        public void clearActions() {
            this.m_6702_().forEach(entry -> entry.switchAction(null));
        }

        private class KeyBindingSetting
        extends ContainerObjectSelectionList.Entry<de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen$KeyBindingList.KeyBindingSetting> {
            private static final ResourceLocation REMOVE_ICON = new ResourceLocation("vampirism", "textures/gui/remove.png");
            private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
            private final int index;
            private final KeyMapping keyMapping;
            private IAction<?> action;
            private StringWidget stringWidget;
            private ImageWidget imageWidget;
            private ImageButton imageButton;

            public KeyBindingSetting(int index, KeyMapping keyMapping, IAction<?> action) {
                this.index = index;
                this.keyMapping = keyMapping;
                this.stringWidget = new StringWidget(0, 2, 80, 20, keyMapping.m_90863_(), Minecraft.m_91087_().f_91062_);
                this.imageButton = new ImageButton(115, 2, 16, 16, 128, 0, 16, REMOVE_ICON, 16, 32, a -> this.switchAction(null));
                this.switchAction(action);
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                if (this.imageButton.m_6375_(pMouseX - (double)KeyBindingList.this.getLeft(), pMouseY - (double)KeyBindingList.this.getTop() - (double)((this.index - 1) * 20), pButton)) {
                    return true;
                }
                if (EditSelectActionScreen.this.movingItem != null) {
                    this.switchAction((IAction)EditSelectActionScreen.this.movingItem.get());
                    EditSelectActionScreen.this.movingItem = null;
                    EditSelectActionScreen.this.removeDummyItems();
                    return true;
                }
                return false;
            }

            private void switchAction(@Nullable IAction<?> action) {
                this.action = action;
                VampirismMod.dispatcher.sendToServer(new ServerboundActionBindingPacket(this.index, this.action));
                FactionPlayerHandler.getOpt((Player)Minecraft.m_91087_().f_91074_).ifPresent(factionPlayerHandler -> factionPlayerHandler.setBoundAction(this.index, this.action, false, false));
                if (action != null) {
                    this.imageWidget = new ImageWidget(90, 2, 16, 16, EditSelectActionScreen.getActionIcon(action));
                    this.imageButton.f_93624_ = true;
                } else {
                    this.imageWidget = new ImageWidget(90, 2, 16, 16, null);
                    this.imageWidget.f_93624_ = false;
                    this.imageButton.f_93624_ = false;
                }
            }

            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.stringWidget, this.imageWidget, this.imageButton);
            }

            public void m_6311_(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean p_93531_, float pPartialTick) {
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_252880_((float)pLeft, (float)pTop, 0.0f);
                this.stringWidget.m_88315_(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                this.imageWidget.m_88315_(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                this.imageButton.m_88315_(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                pGuiGraphics.m_280168_().m_85849_();
            }

            public void m_274437_(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                if (EditSelectActionScreen.this.movingItem != null) {
                    pGuiGraphics.m_280027_(WIDGETS_LOCATION, pLeft, pTop, pWidth, pHeight + 5, 20, 4, 200, 20, 0, 46 + (pIsMouseOver ? 2 : 1) * 20);
                }
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of(this.stringWidget, this.imageWidget, this.imageButton);
            }
        }
    }
}

