/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.FogDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogDiffuserBlock
extends VampirismBlockContainer {
    private static final VoxelShape shape = FogDiffuserBlock.makeShape();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
    }

    public FogDiffuserBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        this.getBlockEntity(pLevel, pPos).ifPresent(blockEntity -> {
            pPlayer.m_36220_(ModStats.interact_with_fog_diffuser);
            blockEntity.interact(itemInHand);
            VampirismMod.proxy.displayFogDiffuserScreen((FogDiffuserBlockEntity)((Object)blockEntity), (Component)this.m_49954_());
        });
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    @NotNull
    protected Optional<FogDiffuserBlockEntity> getBlockEntity(@NotNull Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FogDiffuserBlockEntity) {
            return Optional.of((FogDiffuserBlockEntity)blockEntity);
        }
        return Optional.empty();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new FogDiffuserBlockEntity(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    @Override
    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
        VampirismWorld.getOpt(worldIn).ifPresent(vampirismWorld -> vampirismWorld.updateTemporaryArtificialFog(pos, null));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return FogDiffuserBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModTiles.FOG_DIFFUSER.get()), FogDiffuserBlockEntity::tick);
    }
}

