/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.inventory.PotionTableMenu;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3, 4, 5, 1, 2};
    private static final int[] SLOTS_FOR_DOWN_EXTENDED = new int[]{3, 4, 5, 6, 7, 1, 2};
    private static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5, 0};
    private static final int[] OUTPUT_SLOTS_EXTENDED = new int[]{3, 4, 5, 6, 7, 0};
    private final BrewingCapabilities config = new BrewingCapabilities();
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    @Nullable
    private UUID ownerID;
    @Nullable
    private Component ownerName;
    @NotNull
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private int brewTime;
    private Item ingredientID;
    private Item extraIngredientID;
    private int fuel;
    protected final ContainerData syncedProperties = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PotionTableBlockEntity.this.brewTime;
                case 1 -> PotionTableBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PotionTableBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    PotionTableBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public PotionTableBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.POTION_TABLE.get(), pos, state);
    }

    public boolean m_7525_(@NotNull Player player) {
        if (super.m_7525_(player)) {
            return HunterPlayer.getOpt(player).map(hp -> {
                if (hp.getLevel() > 0) {
                    if (this.ownerID == null) {
                        this.setOwnerID(player);
                        this.config.deriveFromHunter((IHunterPlayer)hp);
                        return true;
                    }
                    if (this.ownerID.equals(player.m_20148_())) {
                        this.config.deriveFromHunter((IHunterPlayer)hp);
                        return true;
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.potion_table.other", (Object[])new Object[]{this.getOwnerName()}), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.unfamiliar"), true);
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        if (index == 2) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.m_41720_();
        if (index == 0) {
            return item == Items.f_42593_;
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.m_8020_(index).m_41619_();
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 1 || index == 2) {
            return stack.m_41720_() == Items.f_42590_;
        }
        return true;
    }

    public void m_6211_() {
        this.brewingItemStacks.clear();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237110_((String)"tile.vampirism.potion_table.display", (Object[])new Object[]{this.ownerName, Component.m_237115_((String)"tile.vampirism.potion_table")});
    }

    @NotNull
    public Component getOwnerName() {
        return this.ownerName == null ? Component.m_237113_((String)"Unknown") : this.ownerName;
    }

    public int m_6643_() {
        return this.brewingItemStacks.size();
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? (this.config.multiTaskBrewing ? SLOTS_FOR_DOWN_EXTENDED : SLOTS_FOR_DOWN) : (this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.f_41583_;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isExtended() {
        return this.config.isMultiTaskBrewing();
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.brewingItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.brewingItemStacks);
        this.brewTime = compound.m_128448_("BrewTime");
        this.fuel = compound.m_128445_("Fuel");
        this.config.fromByte(compound.m_128445_("config"));
        this.ownerID = compound.m_128403_("owner") ? compound.m_128342_("owner") : null;
        this.ownerName = compound.m_128441_("owner_name") ? Component.Serializer.m_130714_((String)compound.m_128461_("owner_name")) : null;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.brewingItemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.brewingItemStacks, (int)index);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)compound, this.brewingItemStacks);
        compound.m_128344_("Fuel", (byte)this.fuel);
        compound.m_128344_("config", this.config.toByte());
        if (this.ownerID != null) {
            compound.m_128362_("owner", this.ownerID);
            compound.m_128359_("owner_name", Component.Serializer.m_130703_((Component)this.ownerName));
        }
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public void setOwnerID(@NotNull Player player) {
        this.ownerID = player.m_20148_();
        this.ownerName = player.m_7755_();
        this.m_6596_();
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (!this.m_58898_()) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public static void tick(@NotNull Level level, BlockPos pos, BlockState state, @NotNull PotionTableBlockEntity blockEntity) {
        boolean isBrewing;
        Player owner;
        ItemStack itemstack = (ItemStack)blockEntity.brewingItemStacks.get(0);
        if (blockEntity.fuel <= 0 && itemstack.m_41720_() == Items.f_42593_) {
            blockEntity.fuel = 20;
            itemstack.m_41774_(1);
            blockEntity.m_6596_();
        }
        if (blockEntity.ownerID != null && level.m_46467_() % 64L == 0L && (owner = level.m_46003_(blockEntity.ownerID)) != null) {
            HunterPlayer.getOpt(owner).ifPresent(blockEntity.config::deriveFromHunter);
        }
        boolean canBrew = blockEntity.canBrew();
        boolean bl = isBrewing = blockEntity.brewTime > 0;
        if (isBrewing) {
            --blockEntity.brewTime;
            if (blockEntity.brewTime == 0 && canBrew) {
                blockEntity.brewPotions();
                blockEntity.m_6596_();
            } else if (!canBrew || blockEntity.ingredientID != ((ItemStack)blockEntity.brewingItemStacks.get(2)).m_41720_() || blockEntity.extraIngredientID != ((ItemStack)blockEntity.brewingItemStacks.get(1)).m_41720_()) {
                blockEntity.brewTime = 0;
                blockEntity.m_6596_();
            }
        } else if (canBrew && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = blockEntity.config.isSwiftBrewing() ? 400 : 200;
            blockEntity.ingredientID = ((ItemStack)blockEntity.brewingItemStacks.get(2)).m_41720_();
            blockEntity.extraIngredientID = ((ItemStack)blockEntity.brewingItemStacks.get(1)).m_41720_();
            blockEntity.m_6596_();
        }
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return new PotionTableMenu(id, player, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()), (Container)this, this.config.multiTaskBrewing, this.syncedProperties);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.brewing");
    }

    private void brewPotions() {
        ItemStack itemstack1;
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        ItemStack extraIngredient = (ItemStack)this.brewingItemStacks.get(1);
        boolean brewed = VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, true);
        if (!brewed) {
            NonNullList copiedBrewingItemStack = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(4)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(5)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(2)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(0)).m_41777_()});
            if (ForgeEventFactory.onPotionAttemptBrew((NonNullList)copiedBrewingItemStack)) {
                this.brewingItemStacks.set(3, (Object)((ItemStack)copiedBrewingItemStack.get(0)));
                this.brewingItemStacks.set(4, (Object)((ItemStack)copiedBrewingItemStack.get(1)));
                this.brewingItemStacks.set(5, (Object)((ItemStack)copiedBrewingItemStack.get(2)));
                this.brewingItemStacks.set(2, (Object)((ItemStack)copiedBrewingItemStack.get(3)));
                this.brewingItemStacks.set(0, (Object)((ItemStack)copiedBrewingItemStack.get(4)));
                return;
            }
            VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, false);
            copiedBrewingItemStack = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(4)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(5)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(2)).m_41777_(), ((ItemStack)this.brewingItemStacks.get(0)).m_41777_()});
            ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
            this.brewingItemStacks.set(3, (Object)((ItemStack)copiedBrewingItemStack.get(0)));
            this.brewingItemStacks.set(4, (Object)((ItemStack)copiedBrewingItemStack.get(1)));
            this.brewingItemStacks.set(5, (Object)((ItemStack)copiedBrewingItemStack.get(2)));
            this.brewingItemStacks.set(2, (Object)((ItemStack)copiedBrewingItemStack.get(3)));
            this.brewingItemStacks.set(0, (Object)((ItemStack)copiedBrewingItemStack.get(4)));
        }
        BlockPos blockpos = this.m_58899_();
        if (ingredientStack.hasCraftingRemainingItem()) {
            itemstack1 = ingredientStack.getCraftingRemainingItem();
            if (ingredientStack.m_41619_()) {
                ingredientStack = itemstack1;
            } else if (!this.f_58857_.f_46443_) {
                Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            }
        }
        if (extraIngredient.hasCraftingRemainingItem()) {
            itemstack1 = extraIngredient.getCraftingRemainingItem();
            if (extraIngredient.m_41619_()) {
                extraIngredient = itemstack1;
            } else if (!this.f_58857_.f_46443_) {
                Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            }
        }
        this.brewingItemStacks.set(2, (Object)ingredientStack);
        this.brewingItemStacks.set(1, (Object)extraIngredient);
        this.f_58857_.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (SoundEvent)ModSounds.POTION_TABLE_CRAFTING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.f_58857_.m_46796_(1035, blockpos, 0);
    }

    private boolean canBrew() {
        ItemStack extraStack = (ItemStack)this.brewingItemStacks.get(1);
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        if (!ingredientStack.m_41619_()) {
            return VampirismAPI.extendedBrewingRecipeRegistry().canBrew(this.brewingItemStacks, ingredientStack, extraStack, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
        }
        return false;
    }

    protected static class BrewingCapabilities
    implements IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities {
        boolean durableBrewing;
        boolean concentratedBrewing;
        boolean swiftBrewing;
        boolean masterBrewing;
        boolean efficientBrewing;
        boolean multiTaskBrewing;

        protected BrewingCapabilities() {
        }

        public void deriveFromHunter(@NotNull IHunterPlayer player) {
            ISkillHandler manager = player.getSkillHandler();
            this.durableBrewing = manager.isSkillEnabled((ISkill)HunterSkills.DURABLE_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.concentratedBrewing = manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.swiftBrewing = manager.isSkillEnabled((ISkill)HunterSkills.SWIFT_BREWING.get());
            this.masterBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MASTER_BREWER.get());
            this.efficientBrewing = manager.isSkillEnabled((ISkill)HunterSkills.EFFICIENT_BREWING.get());
            this.multiTaskBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MULTITASK_BREWING.get());
        }

        public void fromByte(byte d) {
            this.durableBrewing = (d & 1) > 0;
            this.concentratedBrewing = (d & 2) > 0;
            this.swiftBrewing = (d & 4) > 0;
            this.masterBrewing = (d & 8) > 0;
            this.efficientBrewing = (d & 0x10) > 0;
            this.multiTaskBrewing = (d & 0x20) > 0;
        }

        @Override
        public boolean isConcentratedBrewing() {
            return this.concentratedBrewing;
        }

        @Override
        public boolean isDurableBrewing() {
            return this.durableBrewing;
        }

        @Override
        public boolean isEfficientBrewing() {
            return this.efficientBrewing;
        }

        @Override
        public boolean isMasterBrewing() {
            return this.masterBrewing;
        }

        @Override
        public boolean isMultiTaskBrewing() {
            return this.multiTaskBrewing;
        }

        @Override
        public boolean isSwiftBrewing() {
            return this.swiftBrewing;
        }

        public void reset() {
            this.multiTaskBrewing = false;
            this.efficientBrewing = false;
            this.masterBrewing = false;
            this.swiftBrewing = false;
            this.concentratedBrewing = false;
            this.durableBrewing = false;
        }

        public byte toByte() {
            byte d = 0;
            if (this.durableBrewing) {
                d = (byte)(d | 1);
            }
            if (this.concentratedBrewing) {
                d = (byte)(d | 2);
            }
            if (this.swiftBrewing) {
                d = (byte)(d | 4);
            }
            if (this.masterBrewing) {
                d = (byte)(d | 8);
            }
            if (this.efficientBrewing) {
                d = (byte)(d | 0x10);
            }
            if (this.multiTaskBrewing) {
                d = (byte)(d | 0x20);
            }
            return d;
        }
    }
}

