/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class HelperRegistry {
    @NotNull
    private static Map<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncablePlayerCaps = new ConcurrentHashMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>>();
    @NotNull
    private static Map<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncableEntityCaps = new ConcurrentHashMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>>();
    @NotNull
    private static Set<Capability<IPlayerEventListener>> playerEventListenerCaps = ConcurrentHashMap.newKeySet();
    private static Capability<IPlayerEventListener>[] playerEventListenerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncablePlayerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncableEntityCapsFinal;

    @NotNull
    static Capability<IPlayerEventListener>[] getEventListenerCaps() {
        return playerEventListenerCapsFinal;
    }

    @ApiStatus.Internal
    @NotNull
    public static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> getSyncablePlayerCaps() {
        return syncablePlayerCapsFinal;
    }

    @ApiStatus.Internal
    @NotNull
    public static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> getSyncableEntityCaps() {
        return syncableEntityCapsFinal;
    }

    public static void registerSyncableEntityCapability(Capability<ISyncable.ISyncableEntityCapabilityInst> capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncableEntityCaps == Collections.EMPTY_MAP) {
            throw new IllegalStateException("Cannot register syncable entity capability " + String.valueOf(clz) + "(" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        syncableEntityCaps.put(key, capability);
    }

    public static void registerSyncablePlayerCapability(Capability<ISyncable.ISyncableEntityCapabilityInst> capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncablePlayerCaps == Collections.EMPTY_MAP) {
            throw new IllegalStateException("Cannot register syncable property " + String.valueOf(clz) + "(" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        syncablePlayerCaps.put(key, capability);
    }

    public static void registerPlayerEventReceivingCapability(Capability<IPlayerEventListener> capability, Class<? extends IPlayerEventListener> clz) {
        if (playerEventListenerCaps == Collections.EMPTY_SET) {
            throw new IllegalStateException("Cannot register PlayerEventReceiver (" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        playerEventListenerCaps.add(capability);
    }

    static void finish() {
        syncableEntityCapsFinal = ImmutableMap.copyOf(syncableEntityCaps);
        syncableEntityCaps = Collections.emptyMap();
        syncablePlayerCapsFinal = ImmutableMap.copyOf(syncablePlayerCaps);
        syncablePlayerCaps = Collections.emptyMap();
        playerEventListenerCapsFinal = playerEventListenerCaps.toArray(new Capability[0]);
        playerEventListenerCaps = Collections.emptySet();
    }
}

