/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.page.PageIRecipe;
import de.maxanier.guideapi.util.LogHelper;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageJsonRecipe
extends PageIRecipe {
    @Nonnull
    private final ResourceLocation recipeId;
    @Nonnull
    private final Function<Recipe<?>, IRecipeRenderer> recipeRendererSupplier;

    public PageJsonRecipe(ResourceLocation recipeId) {
        this(recipeId, PageIRecipe::getRenderer);
    }

    public PageJsonRecipe(ResourceLocation recipeId, Function<Recipe<?>, IRecipeRenderer> rendererSupplier) {
        super(null, null);
        this.recipeId = recipeId;
        this.recipeRendererSupplier = rendererSupplier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, EntryScreen guiEntry) {
        super.onInit(book, category, entry, player, bookStack, guiEntry);
        if (this.recipe == null) {
            Recipe recipe = this.recipe = Minecraft.m_91087_().m_91403_() == null ? null : (Recipe)Minecraft.m_91087_().m_91403_().m_105141_().m_44043_(this.recipeId).orElse(null);
            if (this.recipe == null) {
                LogHelper.error("Cannot find recipe " + this.recipeId);
            } else if (this.iRecipeRenderer == null) {
                this.iRecipeRenderer = this.recipeRendererSupplier.apply(this.recipe);
                if (this.iRecipeRenderer == null) {
                    LogHelper.error("Did not get renderer for recipe type " + this.recipe.getClass().toString() + " for recipe " + this.recipeId);
                }
            }
        }
        this.isValid = this.recipe != null && this.iRecipeRenderer != null;
    }
}

