/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncHome;
import de.maxanier.guideapi.wrapper.CategoryWrapper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HomeScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public HashMultimap<Integer, CategoryWrapper> categoryWrapperMap = HashMultimap.create();
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int categoryPage;

    public HomeScreen(Book book, Player player, ItemStack bookStack) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.categoryPage = 0;
    }

    public void m_7856_() {
        this.categoryWrapperMap.clear();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.f_96541_.m_91152_((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.m_142416_((GuiEventListener)this.buttonSearch);
        int cX = this.guiLeft + 55;
        int cY = this.guiTop + 40;
        int i = 0;
        int pageNumber = 0;
        for (CategoryAbstract category : this.book.getCategoryList()) {
            if (category.entries.isEmpty()) continue;
            category.onInit(this.book, this, this.player, this.bookStack);
            int x = i % 5;
            int y = i / 5;
            this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX + x * 27, cY + y * 30, 23, 23, this.player, this.f_96547_, false, this.bookStack));
            if (++i < 20) continue;
            i = 0;
            ++pageNumber;
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if ((keyCode == 265 || keyCode == 262) && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            this.nextPage();
        } else if ((keyCode == 264 || keyCode == 263) && this.categoryPage > 0) {
            this.prevPage();
        }
        return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int typeofClick) {
        if (!super.m_6375_(mouseX, mouseY, typeofClick)) {
            for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    wrapper.category.onLeftClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                } else if (typeofClick == 1) {
                    wrapper.category.onRightClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void nextPage() {
        if (this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty()) {
            ++this.categoryPage;
        }
    }

    public void m_7379_() {
        super.m_7379_();
        PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncHome(this.categoryPage));
    }

    public void prevPage() {
        if (this.categoryPage != 0) {
            --this.categoryPage;
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        graphics.m_280218_(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.m_280218_(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawCenteredStringWithoutShadow(graphics, this.f_96547_, this.book.getHeader().m_7532_(), this.guiLeft + this.xSize / 2 + 1, this.guiTop + 15, 0);
        this.categoryPage = Mth.m_14045_((int)this.categoryPage, (int)0, (int)(this.categoryWrapperMap.size() - 1));
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.draw(graphics, Minecraft.m_91087_().f_91073_.m_9598_(), mouseX, mouseY, this);
        }
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.drawExtras(graphics, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.f_96547_, String.format("%d/%d", this.categoryPage + 1, this.categoryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.m_280653_(this.f_96547_, this.book.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.f_93624_ = this.categoryPage != 0;
        this.buttonNext.f_93624_ = this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty();
        super.m_88315_(graphics, mouseX, mouseY, renderPartialTicks);
    }
}

