/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fusion;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import nuclearscience.common.block.BlockPlasma;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fusion.TilePlasma;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileFusionReactorCore
extends GenericTile {
    public final SingleProperty<Integer> deuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "deuterium", (Object)0));
    public final SingleProperty<Integer> tritium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "tritium", (Object)0));
    public final SingleProperty<Integer> timeLeft = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "timeleft", (Object)0));

    public TileFusionReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FUSIONREACTORCORE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK * 20.0).voltage(480.0));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if ((Integer)this.tritium.getValue() > 0 && (Integer)this.deuterium.getValue() > 0 && (Integer)this.timeLeft.getValue() <= 0 && electro.getJoulesStored() > NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
            this.deuterium.setValue((Object)((Integer)this.deuterium.getValue() - 1));
            this.tritium.setValue((Object)((Integer)this.tritium.getValue() - 1));
            this.timeLeft.setValue((Object)300);
        }
        if ((Integer)this.timeLeft.getValue() <= 0) {
            if (BlockEntityUtils.isLit((GenericTile)this)) {
                BlockEntityUtils.updateLit((GenericTile)this, (Boolean)false);
            }
            return;
        }
        if (!BlockEntityUtils.isLit((GenericTile)this)) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)true);
        }
        this.timeLeft.setValue((Object)((Integer)this.timeLeft.getValue() - 1));
        if (electro.getJoulesStored() < NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = this.f_58858_.m_121945_(dir);
            BlockState offsetState = this.f_58857_.m_8055_(offset);
            if (offsetState.m_60734_() == NuclearScienceBlocks.BLOCK_PLASMA.get()) {
                BlockEntity tile = this.f_58857_.m_7702_(offset);
                if (!(tile instanceof TilePlasma)) continue;
                TilePlasma plasma = (TilePlasma)tile;
                if ((Integer)plasma.ticksExisted.getValue() <= 30) continue;
                plasma.ticksExisted.setValue((Object)0);
                continue;
            }
            if (!offsetState.m_60795_()) continue;
            this.f_58857_.m_46597_(offset, ((BlockPlasma)((Object)NuclearScienceBlocks.BLOCK_PLASMA.get())).m_49966_());
        }
        electro.joules(electro.getJoulesStored() - NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK);
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack inHand = player.m_21120_(hand);
        int accepted = 0;
        if (inHand.m_204117_(NuclearScienceTags.Items.CELL_DEUTERIUM)) {
            accepted = this.addDeuteriumCells(inHand.m_41613_());
        } else if (inHand.m_204117_(NuclearScienceTags.Items.CELL_TRITIUM)) {
            accepted = this.addTritiumCells(inHand.m_41613_());
        }
        if (accepted > 0) {
            if (!this.f_58857_.m_5776_()) {
                inHand.m_41764_(inHand.m_41613_() - accepted);
            }
            return InteractionResult.CONSUME;
        }
        return super.use(player, hand, hit);
    }

    public int addDeuteriumCells(int count) {
        return this.addCell(this.deuterium, count);
    }

    public int addTritiumCells(int count) {
        return this.addCell(this.tritium, count);
    }

    private int addCell(SingleProperty<Integer> property, int count) {
        if ((Integer)property.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE) {
            return 0;
        }
        int added = Math.min(count, NuclearConstants.FUSIONREACTOR_MAXSTORAGE - (Integer)property.getValue());
        if (!this.f_58857_.m_5776_()) {
            property.setValue((Object)((Integer)property.getValue() + added));
        }
        return added;
    }

    public boolean isDeuteriumFull() {
        return (Integer)this.deuterium.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE;
    }

    public boolean isTritiumFull() {
        return (Integer)this.tritium.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE;
    }
}

