/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import nuclearscience.api.quantumtunnel.ICapabilityChannelMap;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.registers.NuclearScienceCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityChannelMap
implements ICapabilityChannelMap,
ICapabilitySerializable<CompoundTag> {
    private final HashMap<UUID, HashSet<TunnelFrequency>> map = new HashMap();
    private final LazyOptional<ICapabilityChannelMap> lazyOptional = LazyOptional.of(() -> this);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == NuclearScienceCapabilities.CAPABILITY_CHANNELMAP) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        int size = this.map.size();
        data.m_128405_("size", size);
        int i = 0;
        for (Map.Entry<UUID, HashSet<TunnelFrequency>> entry : this.map.entrySet()) {
            CompoundTag store = new CompoundTag();
            UUIDUtil.f_235867_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("id", tag));
            store.m_128405_("setsize", entry.getValue().size());
            int j = 0;
            for (TunnelFrequency freq : entry.getValue()) {
                int finalJ = j++;
                TunnelFrequency.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)freq).result().ifPresent(tag -> store.m_128365_("" + finalJ, tag));
            }
            data.m_128365_("" + i, (Tag)store);
            ++i;
        }
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (NuclearScienceCapabilities.CAPABILITY_CHANNELMAP == null) {
            return;
        }
        this.map.clear();
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = nbt.m_128469_("" + i);
            Optional id = UUIDUtil.f_235867_.decode((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("id")).result();
            if (!id.isPresent()) continue;
            HashSet set = new HashSet();
            for (int j = 0; j < stored.m_128451_("setsize"); ++j) {
                TunnelFrequency.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("" + j)).result().ifPresent(pair -> set.add((TunnelFrequency)pair.getFirst()));
            }
            this.map.put((UUID)((Pair)id.get()).getFirst(), set);
        }
    }

    @Override
    public HashMap<UUID, HashSet<TunnelFrequency>> getMap() {
        return this.map;
    }
}

