/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.protection;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.protection.ProtectionVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ProtectionFormula(ModifierFormula formula, List<ProtectionVariable> variables, String[] variableNames) implements VariableFormula<ProtectionVariable>
{
    public static final String[] VARIABLES = new String[]{"level", "protection"};
    public static final RecordLoadable<ProtectionFormula> LOADER = new VariableFormulaLoadable<ProtectionVariable, ProtectionFormula>(ProtectionVariable.LOADER, VARIABLES, ModifierFormula.FallbackFormula.ADD, (formula, variables, percent) -> new ProtectionFormula((ModifierFormula)formula, (List<ProtectionVariable>)variables, EMPTY_STRINGS));

    public ProtectionFormula(ModifierFormula formula, Map<String, ProtectionVariable> variables) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables));
    }

    @Override
    public boolean percent() {
        return true;
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable EquipmentContext context, @Nullable LivingEntity target, @Nullable DamageSource source, @Nullable EquipmentSlot slotType, float protection) {
        int size = this.variables.size();
        float[] arguments = new float[VARIABLES.length + size];
        arguments[0] = this.formula.processLevel(modifier);
        arguments[1] = protection;
        for (int i = 0; i < size; ++i) {
            arguments[ProtectionFormula.VARIABLES.length + i] = this.variables.get(i).getValue(tool, context, target, source, slotType);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable EquipmentContext context, @Nullable LivingEntity target, @Nullable EquipmentSlot slotType, @Nullable DamageSource source, float protection) {
        return this.formula.apply(this.getArguments(tool, modifier, context, target, source, slotType, protection));
    }
}

