/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin.entity;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class MixinVillagerEntity
extends AbstractVillager
implements IVillagerTransformable {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(Villager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean werewolf;
    private WerewolfForm form = WerewolfForm.BEAST;
    private final EntityActionTier entityTier = EntityActionTier.Medium;
    private EntityClassType entityClass;
    protected int rage;

    @Deprecated
    public MixinVillagerEntity(EntityType<? extends AbstractVillager> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        EntityType type = this.form == WerewolfForm.BEAST ? (EntityType)ModEntities.WEREWOLF_BEAST.get() : (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
        BasicWerewolfEntity entity = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (Mob)this);
        entity.setSourceEntity(this);
        return entity;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return this.isWerewolf() && (float)this.rage > this.m_21233_() * 4.0f;
    }

    private boolean isWerewolf() {
        return this.werewolf && !(this instanceof IVampire) && ExtendedCreature.getSafe((Entity)this).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) == false;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            if (this.isWerewolf()) {
                this.rage = (int)((float)this.rage + amount * 10.0f);
            }
            return true;
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isWerewolf()) {
            if (this.rage > 150) {
                WerewolfTransformable werewolf = this.transformToWerewolf(TransformType.TIME_LIMITED);
                ((Mob)werewolf).m_6703_(this.m_5448_());
            }
            if (this.m_9236_().m_46467_() % 400L == 10L) {
                if (Helper.isFullMoon(this.m_9236_())) {
                    this.transformToWerewolf(TransformType.FULL_MOON);
                }
                if (this.rage > 10) {
                    this.rage -= 10;
                }
            }
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass == null ? (this.entityClass = EntityClassType.getRandomClass((RandomSource)this.m_217043_())) : this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        int i = (Integer)this.m_20088_().m_135370_(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public void setWerewolfFaction(boolean werewolf) {
        this.werewolf = werewolf;
        if (werewolf) {
            this.form = this.m_217043_().m_188499_() ? WerewolfForm.SURVIVALIST : WerewolfForm.BEAST;
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.m_20088_().m_135370_(TYPE) == -1) {
            this.m_20088_().m_135381_(TYPE, (Object)this.m_217043_().m_188503_(126));
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    protected void werewolves_defineSynchedData(CallbackInfo ci) {
        this.m_20088_().m_135372_(TYPE, (Object)-1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("werewolf", this.werewolf);
        if (this.form != null) {
            nbt.m_128359_("form", this.form.getName());
        }
        nbt.m_128405_("type", this.getSkinType());
        if (this.entityClass != null) {
            nbt.m_128405_("entityclasstype", EntityClassType.getID((EntityClassType)this.entityClass));
        }
        compound.m_128365_("werewolves", (Tag)nbt);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag nbt = compound.m_128469_("werewolves");
        this.werewolf = nbt.m_128471_("werewolf");
        if (nbt.m_128441_("form")) {
            this.form = WerewolfForm.getForm(nbt.m_128461_("form"));
        }
        if (nbt.m_128441_("type")) {
            int t = nbt.m_128451_("type");
            this.m_20088_().m_135381_(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.m_128441_("entityclasstype")) {
            this.entityClass = EntityClassType.getEntityClassType((int)nbt.m_128451_("entityclasstype"));
        }
    }
}

