/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class WerewolfPlayerRenderer<T extends LivingEntity, E extends HumanoidModel<T>>
extends LivingEntityRenderer<T, E> {
    public static Optional<String> getWerewolfRenderer(AbstractClientPlayer player) {
        if (Helper.isWerewolf((Player)player)) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)player);
            WerewolfForm form = werewolf.getForm();
            if (Minecraft.m_91087_().f_91080_ instanceof WerewolfPlayerAppearanceScreen && ((WerewolfPlayerAppearanceScreen)Minecraft.m_91087_().f_91080_).isRenderForm()) {
                form = ((WerewolfPlayerAppearanceScreen)Minecraft.m_91087_().f_91080_).getActiveForm();
            }
            if (form == WerewolfForm.BEAST) {
                return Optional.of("werewolves:beast");
            }
            if (form == WerewolfForm.SURVIVALIST) {
                return Optional.of("werewolves:survivalist");
            }
        }
        return Optional.empty();
    }

    public WerewolfPlayerRenderer(EntityRendererProvider.Context context, E model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    public abstract void renderRightHand(PoseStack var1, MultiBufferSource var2, int var3, T var4);

    public abstract void renderLeftHand(PoseStack var1, MultiBufferSource var2, int var3, T var4);

    protected void renderHand(PoseStack stack, MultiBufferSource bufferSource, int p_117778_, T entity, ModelPart arm) {
        HumanoidModel model = (HumanoidModel)this.m_7200_();
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.f_104203_ = 0.0f;
        arm.m_104301_(stack, bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)this.m_5478_((Entity)entity))), p_117778_, OverlayTexture.f_118083_);
    }

    protected void m_7523_(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f = pEntityLiving.m_20998_(pPartialTicks);
        if (pEntityLiving.m_21255_()) {
            super.m_7523_(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        } else if (f > 0.0f) {
            super.m_7523_(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
            this.setupSwimRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        } else {
            super.m_7523_(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        }
    }

    protected abstract void setupSwimRotations(T var1, PoseStack var2, float var3, float var4, float var5);
}

