/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class WolfBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public WolfBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter block, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)ModItems.WOLF_BERRIES.get());
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter block, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)state.m_61143_((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.m_5940_(state, block, pos, context);
    }

    public boolean m_6724_(BlockState p_57284_) {
        return (Integer)p_57284_.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity instanceof LivingEntity && entity.m_6095_() != EntityType.f_20452_ && entity.m_6095_() != EntityType.f_20550_) {
            entity.m_7601_(state, new Vec3(0.8, 0.75, 0.8));
            if (!(level.f_46443_ || (Integer)state.m_61143_((Property)AGE) <= 0 || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_() || Helper.isWerewolf(entity))) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 0));
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.f_46441_.m_188503_(2);
            WolfBerryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.WOLF_BERRIES.get(), j + (flag ? 1 : 0)));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state, boolean p_50900_) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

