/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.api.IWrenchItem;
import voltaic.api.gas.GasTank;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.client.PacketUpdateCariedItemClient;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.tile.IPropertyHolderTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentName;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.registers.VoltaicCapabilities;

public abstract class GenericTile
extends BlockEntity
implements Nameable,
IPropertyHolderTile {
    private final IComponent[] components = new IComponent[IComponentType.values().length];
    private final PropertyManager propertyManager = new PropertyManager(this);
    public boolean isChanged = false;

    public GenericTile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
    }

    public <T extends AbstractProperty> T property(T prop) {
        for (AbstractProperty existing : this.propertyManager.getProperties()) {
            if (!existing.getName().equals(prop.getName())) continue;
            throw new RuntimeException(prop.getName() + " is already being used by another property!");
        }
        return this.propertyManager.addProperty(prop);
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public boolean hasComponent(IComponentType type) {
        return this.components[type.ordinal()] != null;
    }

    public <T extends IComponent> T getComponent(IComponentType type) {
        return (T)(!this.hasComponent(type) ? null : this.components[type.ordinal()]);
    }

    public GenericTile addComponent(IComponent component) {
        component.holder(this);
        if (this.hasComponent(component.getType())) {
            throw new ExceptionInInitializerError("Component of type: " + component.getType().name() + " already registered!");
        }
        this.components[component.getType().ordinal()] = component;
        return this;
    }

    @Deprecated(since="Try not using this method.")
    public GenericTile forceComponent(IComponent component) {
        component.holder(this);
        this.components[component.getType().ordinal()] = component;
        return this;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (this.propertyManager != null && compound.m_128441_("propertydata")) {
            CompoundTag propertyData = compound.m_128469_("propertydata");
            this.propertyManager.loadFromTag(propertyData);
            compound.m_128473_("propertydata");
        }
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.holder(this);
            component.loadFromNBT(compound);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.propertyManager != null) {
            CompoundTag propertyData = new CompoundTag();
            this.propertyManager.saveToTag(propertyData);
            compound.m_128365_("propertydata", (Tag)propertyData);
        }
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.holder(this);
            component.saveToNBT(compound);
        }
        super.m_183515_(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.propertyManager != null) {
            CompoundTag propertyData = new CompoundTag();
            this.propertyManager.saveAllPropsForClientSync(propertyData);
            tag.m_128365_("propertydata", (Tag)propertyData);
            this.propertyManager.clean();
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tile -> {
            CompoundTag tag = new CompoundTag();
            CompoundTag data = new CompoundTag();
            this.propertyManager.saveDirtyPropsToTag(data);
            tag.m_128365_("propertydata", (Tag)data);
            return tag;
        });
    }

    public void onLoad() {
        super.onLoad();
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.holder(this);
            component.onLoad();
        }
        if (this.propertyManager != null) {
            this.propertyManager.onTileLoaded();
        }
    }

    public @NotNull Component m_7755_() {
        return this.hasComponent(IComponentType.Name) ? ((ComponentName)this.getComponent(IComponentType.Name)).getName() : Component.m_237113_((String)"voltaic.default.tile.name");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK && this.components[IComponentType.Electrodynamic.ordinal()] != null) {
            return this.components[IComponentType.Electrodynamic.ordinal()].getCapability(cap, side, null);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.components[IComponentType.FluidHandler.ordinal()] != null) {
            return this.components[IComponentType.FluidHandler.ordinal()].getCapability(cap, side, null);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.components[IComponentType.Inventory.ordinal()] != null) {
            return this.components[IComponentType.Inventory.ordinal()].getCapability(cap, side, null);
        }
        if (cap == VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK && this.components[IComponentType.GasHandler.ordinal()] != null) {
            return this.components[IComponentType.GasHandler.ordinal()].getCapability(cap, side, null);
        }
        if (cap == ForgeCapabilities.ENERGY && this.components[IComponentType.ForgeEnergy.ordinal()] != null) {
            return this.components[IComponentType.ForgeEnergy.ordinal()].getCapability(cap, side, null);
        }
        return LazyOptional.empty();
    }

    public void m_7651_() {
        super.m_7651_();
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.holder(this);
            component.remove();
        }
    }

    public SimpleContainerData getCoordsArray() {
        SimpleContainerData array = new SimpleContainerData(5);
        array.m_8050_(0, this.f_58858_.m_123341_() / 30000);
        array.m_8050_(1, this.m_58899_().m_123341_() % 30000);
        array.m_8050_(2, this.f_58858_.m_123342_());
        array.m_8050_(3, this.f_58858_.m_123343_() / 30000);
        array.m_8050_(4, this.m_58899_().m_123343_() % 30000);
        return array;
    }

    public boolean isPoweredByRedstone() {
        return this.f_58857_.m_277173_(this.f_58858_) > 0;
    }

    public Direction getFacing() {
        return this.m_58900_().m_61138_((Property)VoltaicBlockStates.FACING) ? (Direction)this.m_58900_().m_61143_((Property)VoltaicBlockStates.FACING) : Direction.NORTH;
    }

    public void onEnergyChange(ComponentElectrodynamic cap) {
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        if (this.hasComponent(IComponentType.Processor)) {
            ((ComponentProcessor)this.getComponent(IComponentType.Processor)).onInventoryChange(inv, slot);
        }
    }

    public void onFluidTankChange(FluidTank tank) {
    }

    public void onGasTankChange(GasTank tank) {
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public InteractionResult use(Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemUpgrade upgrade;
        ItemStack stack;
        block8: {
            block7: {
                stack = player.m_21120_(handIn);
                Item item = stack.m_41720_();
                if (!(item instanceof ItemUpgrade)) break block7;
                upgrade = (ItemUpgrade)item;
                if (this.hasComponent(IComponentType.Inventory)) break block8;
            }
            if (stack.m_41720_() instanceof IWrenchItem) return InteractionResult.PASS;
            if (!this.hasComponent(IComponentType.ContainerProvider)) return InteractionResult.PASS;
            if (this.f_58857_.f_46443_) return InteractionResult.CONSUME;
            player.m_5893_((MenuProvider)this.getComponent(IComponentType.ContainerProvider));
            player.m_36220_(Stats.f_12966_);
            return InteractionResult.CONSUME;
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        if (inv == null) return InteractionResult.PASS;
        if (inv.upgrades() <= 0) return InteractionResult.PASS;
        int upgradeIndex = inv.getUpgradeSlotStartIndex();
        int i = 0;
        while (i < inv.upgrades()) {
            if (inv.m_7013_(upgradeIndex + i, stack)) {
                int room;
                ItemStack upgradeStack = inv.m_8020_(upgradeIndex + i);
                if (upgradeStack.m_41619_()) {
                    if (this.f_58857_.m_5776_()) return InteractionResult.CONSUME;
                    inv.m_6836_(upgradeIndex + i, stack.m_41777_());
                    stack.m_41774_(stack.m_41613_());
                    return InteractionResult.CONSUME;
                }
                if (ItemUtils.testItems(upgrade, upgradeStack.m_41720_()) && (room = upgradeStack.m_41741_() - upgradeStack.m_41613_()) > 0) {
                    if (this.f_58857_.m_5776_()) return InteractionResult.CONSUME;
                    int accepted = room > stack.m_41613_() ? stack.m_41613_() : room;
                    upgradeStack.m_41769_(accepted);
                    stack.m_41774_(accepted);
                    return InteractionResult.CONSUME;
                }
            }
            ++i;
        }
        return InteractionResult.PASS;
    }

    public void onBlockDestroyed() {
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.holder(this);
            component.onLoad();
        }
    }

    public int getComparatorSignal() {
        return 0;
    }

    public int getDirectSignal(Direction dir) {
        return 0;
    }

    public int getSignal(Direction dir) {
        return 0;
    }

    public void onEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
    }

    public void updateCarriedItemInContainer(ItemStack stack, UUID playerId) {
        ServerPlayer player = (ServerPlayer)this.m_58904_().m_46003_(playerId);
        if (player.m_242612_()) {
            player.f_36096_.m_142503_(stack);
            stack.m_41784_().m_128379_("hasclickedonfluidgauge", false);
            player.f_36096_.m_142503_(stack);
            NetworkHandler.CHANNEL.sendTo((Object)new PacketUpdateCariedItemClient(stack, this.f_58858_, playerId), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    protected static TriPredicate<Integer, ItemStack, ComponentInventory> machineValidator() {
        return (x, y, i) -> {
            if (x < i.getOutputStartIndex()) return true;
            if (x >= i.getInputBucketStartIndex() && x < i.getInputGasStartIndex()) {
                if (y.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM) != null) return true;
            }
            if (x >= i.getInputGasStartIndex() && x < i.getUpgradeSlotStartIndex()) {
                if (y.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM) != null) return true;
            }
            if (x < i.getUpgradeSlotStartIndex()) return false;
            Item patt12534$temp = y.m_41720_();
            if (!(patt12534$temp instanceof ItemUpgrade)) return false;
            ItemUpgrade upgrade = (ItemUpgrade)patt12534$temp;
            if (!i.isUpgradeValid(upgrade.subtype)) return false;
            return true;
        };
    }

    public static final int[] arr(int ... values) {
        return values;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        for (IComponent component : this.components) {
            if (component == null) continue;
            component.refreshIfUpdate(oldState, newState);
        }
    }

    public void setPlacedBy(LivingEntity player, ItemStack stack) {
    }
}

