/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.function.DoubleSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;

@OnlyIn(value=Dist.CLIENT)
public class ScreenComponentProgress
extends ScreenComponentGeneric {
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/progress.png");
    private final DoubleSupplier progressInfoHandler;
    private final ProgressBars bar;

    public ScreenComponentProgress(ProgressBars progressBar, DoubleSupplier progressInfoHandler, int x, int y) {
        super(progressBar.off, x, y);
        this.progressInfoHandler = progressInfoHandler;
        this.bar = progressBar;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        ProgressTextures on = this.bar.on;
        switch (this.bar) {
            case PROGRESS_ARROW_LEFT: {
                int progress = (int)(this.progressInfoHandler.getAsDouble() * (double)on.textureWidth());
                int xStart = on.textureU() + on.textureWidth() - progress;
                graphics.m_280163_(on.getLocation(), guiWidth + this.xLocation + on.textureWidth() - progress, guiHeight + this.yLocation, (float)xStart, (float)on.textureV(), progress, on.textureHeight(), on.imageWidth(), on.imageHeight());
                break;
            }
            case COUNTDOWN_FLAME: 
            case FAN: {
                int progress = (int)(this.progressInfoHandler.getAsDouble() * (double)on.textureHeight());
                graphics.m_280163_(on.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation + on.textureHeight() - progress, (float)on.textureU(), (float)(on.textureV() + on.textureHeight() - progress), on.textureWidth(), progress, on.imageWidth(), on.imageHeight());
                break;
            }
            case PROGRESS_ARROW_RIGHT: 
            case BATTERY_CHARGE_RIGHT: 
            case PROGRESS_ARROW_RIGHT_BIG: {
                graphics.m_280163_(on.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)on.textureU(), (float)on.textureV(), (int)(this.progressInfoHandler.getAsDouble() * (double)on.textureWidth()), on.textureHeight(), on.imageWidth(), on.imageHeight());
                break;
            }
        }
    }

    public static enum ProgressBars {
        PROGRESS_ARROW_RIGHT(ProgressTextures.ARROW_RIGHT_OFF, ProgressTextures.ARROW_RIGHT_ON),
        PROGRESS_ARROW_LEFT(ProgressTextures.ARROW_LEFT_OFF, ProgressTextures.ARROW_LEFT_ON),
        COUNTDOWN_FLAME(ProgressTextures.FLAME_OFF, ProgressTextures.FLAME_ON),
        BATTERY_CHARGE_RIGHT(ProgressTextures.BATTER_CHARGE_RIGHT_OFF, ProgressTextures.BATTER_CHARGE_RIGHT_ON),
        PROGRESS_ARROW_RIGHT_BIG(ProgressTextures.ARROW_RIGHT_BIG_OFF, ProgressTextures.ARROW_RIGHT_BIG_ON),
        FAN(ProgressTextures.FAN_OFF, ProgressTextures.FAN_ON);

        public final ProgressTextures off;
        public final ProgressTextures on;

        private ProgressBars(ProgressTextures off, ProgressTextures on) {
            this.off = off;
            this.on = on;
        }
    }

    public static enum ProgressTextures implements ITexture
    {
        ARROW_RIGHT_OFF(22, 16, 0, 0, 44, 16, "arrow_right"),
        ARROW_RIGHT_ON(22, 16, 22, 0, 44, 16, "arrow_right"),
        ARROW_RIGHT_BIG_OFF(64, 15, 0, 0, 64, 30, "arrow_right_big"),
        ARROW_RIGHT_BIG_ON(64, 15, 0, 15, 64, 30, "arrow_right_big"),
        ARROW_LEFT_ON(22, 16, 0, 0, 44, 16, "arrow_left"),
        ARROW_LEFT_OFF(22, 16, 22, 0, 44, 16, "arrow_left"),
        FLAME_ON(14, 14, 0, 0, 14, 28, "flame"),
        FLAME_OFF(14, 14, 0, 14, 14, 28, "flame"),
        BATTER_CHARGE_RIGHT_OFF(19, 10, 0, 0, 38, 10, "battery_charge"),
        BATTER_CHARGE_RIGHT_ON(19, 10, 19, 0, 38, 10, "battery_charge"),
        COMPRESS_ARROW_OFF(15, 9, 0, 0, 15, 9, "compressarrow"),
        DECOMPRESS_ARROW_OFF(15, 9, 0, 0, 15, 9, "decompressarrow"),
        FEYNMAN_DIAGRAM_OFF(65, 46, 0, 0, 65, 92, "feynman_diagram"),
        FEYNMAN_DIAGRAM_ON(65, 46, 0, 46, 65, 92, "feynman_diagram"),
        FAN_OFF(17, 17, 0, 0, 34, 17, "fan"),
        FAN_ON(17, 17, 17, 0, 34, 17, "fan");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private ProgressTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/progress/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

