/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.screenhandlers;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.gas.GasStack;
import voltaic.client.guidebook.ScreenGuidebook;
import voltaic.client.guidebook.utils.components.Page;
import voltaic.client.guidebook.utils.pagedata.graphics.AbstractGraphicWrapper;
import voltaic.compatibility.jei.screenhandlers.cliableingredients.ClickableFluidIngredient;
import voltaic.compatibility.jei.screenhandlers.cliableingredients.ClickableGasIngredient;
import voltaic.compatibility.jei.screenhandlers.cliableingredients.ClickableItemIngredient;

public class ScreenHandlerGuidebook
implements IGuiContainerHandler<ScreenGuidebook> {
    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(ScreenGuidebook screen, double mouseX, double mouseY) {
        int guiHeight;
        int yAxis;
        int guiWidth;
        int xAxis;
        int refY;
        int refX = screen.getXRef();
        Optional<IClickableIngredient<?>> returned = ScreenHandlerGuidebook.getJeiLookup(-83, (int)mouseX, (int)mouseY, refX, refY = screen.getYRef(), xAxis = (int)(mouseX - (double)(guiWidth = (int)screen.getGuiWidth())), yAxis = (int)(mouseY - (double)(guiHeight = (int)screen.getGuiHeight())), guiWidth, guiHeight, screen.getCurrentPage(), screen);
        if (returned.isPresent()) {
            return returned;
        }
        return ScreenHandlerGuidebook.getJeiLookup(80, (int)mouseX, (int)mouseY, refX, refY, xAxis, yAxis, guiWidth, guiHeight, screen.getNextPage(), screen);
    }

    private static Optional<IClickableIngredient<?>> getJeiLookup(int xPageShift, int mouseX, int mouseY, int refX, int refY, int xAxis, int yAxis, int guiWidth, int guiHeight, Page page, ScreenGuidebook screen) {
        int textWidth = 0;
        int xShift = 0;
        int x = 0;
        int y = 0;
        for (Page.TextWrapper text : page.keyPressText) {
            textWidth = screen.getFontRenderer().m_92852_(text.characters());
            if (text.centered()) {
                xShift = (154 - textWidth) / 2;
            }
            if (!screen.isPointInRegionText(x = refX + xShift + xPageShift + text.x(), y = refY + text.y(), xAxis, yAxis, textWidth, 10)) continue;
            return ScreenHandlerGuidebook.handleLookup(text.onKeyPress().getJeiLookup(), new Rect2i(x, y, textWidth, 10));
        }
        for (Page.GraphicWrapper wrapper : page.keyPressGraphics) {
            AbstractGraphicWrapper<?> image = wrapper.graphic();
            x = guiWidth + wrapper.x() + image.lookupXOffset + xPageShift;
            if (screen.isPointInRegionGraphic(mouseX, mouseY, x, y = guiHeight + wrapper.y() + image.lookupYOffset - image.descriptorTopOffset, image.width, image.height)) {
                return ScreenHandlerGuidebook.handleLookup(wrapper.onKeyPress().getJeiLookup(), new Rect2i(x, y, image.width, image.height));
            }
            for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : image.descriptors) {
                x = refX + wrapper.x() + descriptor.xOffsetFromImage + xPageShift;
                y = refY + wrapper.y() + descriptor.yOffsetFromImage;
                if (descriptor.onKeyPress == null || !screen.isPointInRegionText(x, y, xAxis, yAxis, screen.getFontRenderer().m_92852_((FormattedText)descriptor.text), 10)) continue;
                return ScreenHandlerGuidebook.handleLookup(descriptor.onKeyPress.getJeiLookup(), new Rect2i(x, y, screen.getFontRenderer().m_92852_((FormattedText)descriptor.text), 10));
            }
        }
        return Optional.empty();
    }

    private static Optional<IClickableIngredient<?>> handleLookup(Object lookup, Rect2i area) {
        if (lookup instanceof ItemStack) {
            ItemStack stack = (ItemStack)lookup;
            return Optional.of(new ClickableItemIngredient(area, stack));
        }
        if (lookup instanceof FluidStack) {
            FluidStack stack = (FluidStack)lookup;
            return Optional.of(new ClickableFluidIngredient(area, stack));
        }
        if (lookup instanceof GasStack) {
            GasStack stack = (GasStack)lookup;
            return Optional.of(new ClickableGasIngredient(area, stack));
        }
        return Optional.empty();
    }

    public List<Rect2i> getGuiExtraAreas(ScreenGuidebook screen) {
        Rect2i area = new Rect2i(screen.getGuiLeft() + -83, screen.getGuiTop(), 342, 224);
        return Arrays.asList(area);
    }
}

