/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.registers.VoltaicRegistries;

public class GasIngredient
extends Ingredient {
    public static final Codec<GasIngredient> CODEC_DIRECT_GAS = RecordCodecBuilder.create(instance -> instance.group((App)VoltaicRegistries.gasRegistry().getCodec().fieldOf("gas").forGetter(instance0 -> instance0.gas), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.amount), (App)Codec.INT.fieldOf("temp").forGetter(instance0 -> instance0.temperature), (App)Codec.INT.fieldOf("pressure").forGetter(instance0 -> instance0.pressure)).apply((Applicative)instance, GasIngredient::new));
    public static final Codec<GasIngredient> CODEC_TAGGED_GAS = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_(VoltaicRegistries.GAS_REGISTRY_KEY).fieldOf("tag").forGetter(instance0 -> instance0.tag), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.amount), (App)Codec.INT.fieldOf("temp").forGetter(instance0 -> instance0.temperature), (App)Codec.INT.fieldOf("pressure").forGetter(instance0 -> instance0.pressure)).apply((Applicative)instance, GasIngredient::new));
    public static final Codec<GasIngredient> CODEC = Codec.either(CODEC_TAGGED_GAS, CODEC_DIRECT_GAS).xmap(either -> (GasIngredient)((Object)((Object)either.map(tag -> tag, gas -> gas))), value -> {
        if (value.tag != null) {
            return Either.left((Object)value);
        }
        if (value.gas != null) {
            return Either.right((Object)value);
        }
        throw new UnsupportedOperationException("The Gas Ingredient neither has a tag nor a direct gas value defined!");
    });
    public static final Codec<List<GasIngredient>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, GasIngredient> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, GasIngredient>(){

        @Override
        public void encode(FriendlyByteBuf buf, GasIngredient ing) {
            List<GasStack> gasStacks = ing.getMatchingGases();
            buf.writeInt(gasStacks.size());
            for (GasStack stack : gasStacks) {
                GasStack.STREAM_CODEC.encode(buf, stack);
            }
        }

        @Override
        public GasIngredient decode(FriendlyByteBuf buf) {
            ArrayList<GasStack> stacks = new ArrayList<GasStack>();
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                stacks.add(GasStack.STREAM_CODEC.decode(buf));
            }
            return new GasIngredient(stacks);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<GasIngredient>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<GasIngredient>>(){

        @Override
        public void encode(FriendlyByteBuf buf, List<GasIngredient> ings) {
            buf.writeInt(ings.size());
            for (GasIngredient ing : ings) {
                STREAM_CODEC.encode(buf, ing);
            }
        }

        @Override
        public List<GasIngredient> decode(FriendlyByteBuf buf) {
            int length = buf.readInt();
            ArrayList<GasIngredient> ings = new ArrayList<GasIngredient>();
            for (int i = 0; i < length; ++i) {
                ings.add(STREAM_CODEC.decode(buf));
            }
            return ings;
        }
    };
    @Nonnull
    private List<GasStack> gasStacks;
    @Nullable
    private TagKey<Gas> tag;
    @Nullable
    private Gas gas;
    private int amount;
    private int temperature;
    private int pressure;

    public GasIngredient(Gas gas, int amount, int temperature, int pressure) {
        this(new GasStack(gas, amount, temperature, pressure));
    }

    public GasIngredient(GasStack gasStack) {
        super(Stream.empty());
        this.gas = gasStack.getGas();
        this.amount = gasStack.getAmount();
        this.temperature = gasStack.getTemperature();
        this.pressure = gasStack.getPressure();
    }

    public GasIngredient(List<GasStack> stacks) {
        super(Stream.empty());
        this.gasStacks = stacks;
        GasStack gas = this.getGasStack();
        this.gas = gas.getGas();
        this.amount = gas.getAmount();
        this.temperature = gas.getTemperature();
        this.pressure = gas.getPressure();
    }

    public GasIngredient(TagKey<Gas> tag, int amount, int temperature, int pressure) {
        super(Stream.empty());
        this.tag = tag;
        this.amount = amount;
        this.temperature = temperature;
        this.pressure = pressure;
    }

    public boolean test(ItemStack stack) {
        return false;
    }

    public ItemStack[] m_43908_() {
        return new ItemStack[0];
    }

    public boolean isSimple() {
        return false;
    }

    public boolean testGas(@Nullable GasStack gas, boolean checkTemperature, boolean checkPressure) {
        if (gas == null || gas.isEmpty()) {
            return false;
        }
        for (GasStack g : this.getMatchingGases()) {
            if (gas.getAmount() < g.getAmount() || !g.isSameGas(gas)) continue;
            if (!checkTemperature && !checkPressure) {
                return true;
            }
            boolean sameTemp = g.isSameTemperature(gas);
            boolean samePres = g.isSamePressure(gas);
            if (!checkTemperature) {
                return samePres;
            }
            if (checkPressure) {
                return sameTemp && samePres;
            }
            return sameTemp;
        }
        return false;
    }

    public GasStack getGasStack() {
        return this.getMatchingGases().size() < 1 ? GasStack.EMPTY : this.getMatchingGases().get(0);
    }

    public List<GasStack> getMatchingGases() {
        if (this.gasStacks == null) {
            this.gasStacks = new ArrayList<GasStack>();
            if (this.tag != null) {
                VoltaicRegistries.gasRegistry().tags().getTag(this.tag).forEach(h -> this.gasStacks.add(new GasStack((Gas)h, this.amount, this.temperature, this.pressure)));
            } else if (this.gas != null) {
                this.gasStacks.add(new GasStack(this.gas, this.amount, this.temperature, this.pressure));
            } else {
                throw new UnsupportedOperationException("Gas Ingredient has neither a gas nor a gas tag defined");
            }
        }
        return this.gasStacks;
    }

    public String toString() {
        return this.getGasStack().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GasIngredient) {
            GasIngredient ing = (GasIngredient)((Object)obj);
            return ing.getMatchingGases().equals(this.getMatchingGases()) && ing.amount == this.amount && ing.pressure == this.pressure && ing.temperature == this.temperature;
        }
        return false;
    }

    public boolean testGas(GasStack gasStack) {
        return this.testGas(gasStack, true, true);
    }
}

