/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluid2item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import voltaic.common.recipe.recipeutils.AbstractMaterialRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;

public abstract class Fluid2ItemRecipe
extends AbstractMaterialRecipe {
    private List<FluidIngredient> inputFluids;
    private ItemStack outputItem;

    public Fluid2ItemRecipe(ResourceLocation group, List<FluidIngredient> fluidInputs, ItemStack itemOutput, double experience, int ticks, double usagePerTick, List<ProbableItem> itemBiproducts, List<ProbableFluid> fluidBiproducts, List<ProbableGas> gasBiproducts) {
        super(group, experience, ticks, usagePerTick, itemBiproducts, fluidBiproducts, gasBiproducts);
        this.inputFluids = fluidInputs;
        this.outputItem = itemOutput;
    }

    @Override
    public boolean matchesRecipe(ComponentProcessor pr, int procNumber) {
        Pair<List<Integer>, Boolean> pair = Fluid2ItemRecipe.areFluidsValid(this.getFluidIngredients(), ((ComponentFluidHandlerMulti)pr.getHolder().getComponent(IComponentType.FluidHandler)).getInputTanks());
        if (((Boolean)pair.getSecond()).booleanValue()) {
            this.setFluidArrangement((List)pair.getFirst());
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItemRecipeOutput() {
        return this.outputItem;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        ArrayList<FluidIngredient> list = new ArrayList<FluidIngredient>();
        for (FluidIngredient ing : this.inputFluids) {
            list.add(ing);
        }
        return list;
    }

    public static interface Factory<T extends Fluid2ItemRecipe> {
        public T create(ResourceLocation var1, List<FluidIngredient> var2, ItemStack var3, double var4, int var6, double var7, List<ProbableItem> var9, List<ProbableFluid> var10, List<ProbableGas> var11);
    }
}

