/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.common.packet.types.server.ServerBarrierMethods;

public class PacketSwapBattery {
    public static final StreamCodec<ByteBuf, PacketSwapBattery> CODEC = new StreamCodec<ByteBuf, PacketSwapBattery>(){

        @Override
        public void encode(ByteBuf buffer, PacketSwapBattery value) {
            StreamCodec.UUID.encode(buffer, value.playerId);
        }

        @Override
        public PacketSwapBattery decode(ByteBuf buffer) {
            return new PacketSwapBattery(StreamCodec.UUID.decode(buffer));
        }
    };
    private final UUID playerId;

    public PacketSwapBattery(UUID uuid) {
        this.playerId = uuid;
    }

    public static void handle(PacketSwapBattery message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel world = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            if (world != null) {
                ServerBarrierMethods.handleSwapBattery((Level)world, message.playerId);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSwapBattery message, FriendlyByteBuf buf) {
        CODEC.encode((ByteBuf)buf, message);
    }

    public static PacketSwapBattery decode(FriendlyByteBuf buf) {
        return CODEC.decode((ByteBuf)buf);
    }
}

