/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WiredModemFullBlockEntity
extends BlockEntity {
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean refreshConnections = false;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this.tickToken));
    private final WiredModemElement element = new FullElement(this);
    private final WiredNode node = this.element.getNode();
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());
    private int invalidSides = 0;

    public WiredModemFullBlockEntity(BlockEntityType<WiredModemFullBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        ComponentAccess<IPeripheral> peripheralAccess = PlatformHelper.get().createPeripheralAccess(this, this::queueRefreshPeripheral);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i] = new WiredModemLocalPeripheral(peripheralAccess);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        for (WiredModemPeripheral modem : this.modems) {
            if (modem == null) continue;
            modem.removed();
        }
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.refreshConnections = true;
        this.invalidSides = 63;
        TickScheduler.schedule(this.tickToken);
    }

    void neighborChanged(BlockPos neighbour) {
        for (Direction facing : DirectionUtil.FACINGS) {
            if (!this.m_58899_().m_121945_(facing).equals((Object)neighbour)) continue;
            this.queueRefreshPeripheral(facing);
        }
    }

    void queueRefreshPeripheral(Direction facing) {
        this.invalidSides |= 1 << facing.ordinal();
        TickScheduler.schedule(this.tickToken);
    }

    public InteractionResult use(Player player) {
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        List<String> oldPeriphNames = this.getConnectedPeripheralNames();
        if (this.isPeripheralOn()) {
            this.detachPeripherals();
        } else {
            this.attachPeripherals(63);
        }
        List<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equals(periphNames, oldPeriphNames)) {
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return InteractionResult.CONSUME;
    }

    private static void sendPeripheralChanges(Player player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        MutableComponent base = Component.m_237113_((String)"");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.m_130946_(", ");
            }
            base.m_7220_((Component)ChatHelpers.copy((String)names.get(i)));
        }
        player.m_5661_((Component)Component.m_237110_((String)kind, (Object[])new Object[]{base}), false);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.m_183515_(nbt);
    }

    void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidSides != 0) {
            int oldInvalidSides = this.invalidSides;
            this.invalidSides = 0;
            if (this.isPeripheralOn()) {
                this.attachPeripherals(oldInvalidSides);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateModemBlockState();
        }
        if (this.refreshConnections) {
            this.connectionsChanged();
        }
    }

    private void updateModemBlockState() {
        BlockState state = this.m_58900_();
        boolean modemOn = this.modemState.isOpen();
        if ((Boolean)state.m_61143_((Property)WiredModemFullBlock.MODEM_ON) == modemOn) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)WiredModemFullBlock.MODEM_ON, (Comparable)Boolean.valueOf(modemOn)));
    }

    private void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    private void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.refreshConnections = false;
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredElement element;
            BlockPos offset = current.m_121945_(facing);
            if (!world.m_46749_(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            this.node.connectTo(element.getNode());
        }
    }

    private List<String> getConnectedPeripheralNames() {
        ArrayList<String> peripherals = new ArrayList<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        peripherals.sort(String::compareTo);
        return peripherals;
    }

    private void attachPeripherals(int sides) {
        boolean anyChanged = false;
        HashMap<String, IPeripheral> attachedPeripherals = new HashMap<String, IPeripheral>(6);
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
            if (DirectionUtil.isSet(sides, facing)) {
                anyChanged |= peripheral.attach(this.m_58904_(), this.m_58899_(), facing);
            }
            peripheral.extendMap(attachedPeripherals);
        }
        if (anyChanged) {
            this.node.updatePeripherals(attachedPeripherals);
        }
        this.updatePeripheralBlocKState(!attachedPeripherals.isEmpty());
    }

    private void detachPeripherals() {
        boolean anyChanged = false;
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            anyChanged |= peripheral.detach();
        }
        if (anyChanged) {
            this.node.updatePeripherals(Map.of());
        }
        this.updatePeripheralBlocKState(false);
    }

    private void updatePeripheralBlocKState(boolean peripheralOn) {
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)WiredModemFullBlock.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)WiredModemFullBlock.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    private boolean isPeripheralOn() {
        return (Boolean)this.m_58900_().m_61143_((Property)WiredModemFullBlock.PERIPHERAL_ON);
    }

    public WiredElement getElement() {
        return this.element;
    }

    @Nullable
    public WiredModemPeripheral getPeripheral(final @Nullable Direction side) {
        if (side == null) {
            return null;
        }
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element, this.peripherals[side.ordinal()], this){

            @Override
            public Vec3 getPosition() {
                return Vec3.m_82512_((Vec3i)WiredModemFullBlockEntity.this.m_58899_().m_121945_(side));
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final WiredModemFullBlockEntity entity;

        private FullElement(WiredModemFullBlockEntity entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        public Level getLevel() {
            return this.entity.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)this.entity.m_58899_());
        }
    }
}

