/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.client;

import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.block.subtype.SubtypeFluidPipe;
import electrodynamics.common.block.subtype.SubtypeGasPipe;
import electrodynamics.common.block.subtype.SubtypeGlass;
import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.block.subtype.SubtypeOre;
import electrodynamics.common.block.subtype.SubtypeOreDeepslate;
import electrodynamics.common.block.subtype.SubtypeRawOreBlock;
import electrodynamics.common.block.subtype.SubtypeResourceBlock;
import electrodynamics.common.block.subtype.SubtypeWire;
import electrodynamics.datagen.DataGenerators;
import electrodynamics.registers.ElectrodynamicsBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import voltaic.Voltaic;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.datagen.utils.client.BaseBlockstateProvider;

public class ElectrodynamicsBlockStateProvider
extends BaseBlockstateProvider {
    public ElectrodynamicsBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, exFileHelper, "electrodynamics");
        exFileHelper.trackGenerated(Voltaic.rl((String)"block/steelcasing"), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures"));
    }

    protected void registerStatesAndModels() {
        for (SubtypeGlass subtypeGlass : SubtypeGlass.values()) {
            this.glassBlock((Block)ElectrodynamicsBlocks.BLOCKS_CUSTOMGLASS.getValue((Object)subtypeGlass), this.blockLoc("glass/" + subtypeGlass.tag()), true);
        }
        for (Enum enum_ : SubtypeOre.values()) {
            this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_ORE.getValue((Object)enum_), this.blockLoc("ore/" + ((SubtypeOre)enum_).tag()), true);
        }
        for (Enum enum_ : SubtypeOreDeepslate.values()) {
            this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_DEEPSLATEORE.getValue((Object)enum_), this.blockLoc("deepslateore/" + ((SubtypeOreDeepslate)enum_).tag()), true);
        }
        for (Enum enum_ : SubtypeRawOreBlock.values()) {
            this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_RAWORE.getValue((Object)enum_), this.blockLoc("raworeblock/" + ((SubtypeRawOreBlock)enum_).tag()), true);
        }
        for (Enum enum_ : SubtypeResourceBlock.values()) {
            this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_RESOURCE.getValue((Object)enum_), this.blockLoc("resource/" + ((SubtypeResourceBlock)enum_).tag()), true);
        }
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.advancedsolarpanel), (ModelFile)this.existingBlock(this.blockLoc("advancedsolarpanelbase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.batterybox), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.batterybox)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.lithiumbatterybox), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.lithiumbatterybox)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.carbynebatterybox), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.carbynebatterybox)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargerlv), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargerlv)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargermv), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargermv)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargerhv), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chargerhv)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chemicalcrystallizer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chemicalcrystallizer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chemicalmixer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.chemicalmixer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.circuitbreaker), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.circuitbreaker)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.coalgenerator), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.coalgenerator)), (ModelFile)this.existingBlock(this.blockLoc("coalgeneratorrunning")), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.combustionchamber), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.combustionchamber)), true).transforms().transform(ItemDisplayContext.GUI).rotation(35.0f, 40.0f, 0.0f).scale(0.665f).end();
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.coolantresavoir), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.coolantresavoir)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativefluidsource), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativefluidsource)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativepowersource), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativepowersource)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativegassource), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.creativegassource)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.downgradetransformer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.downgradetransformer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.upgradetransformer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.upgradetransformer)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnace), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnace)), (ModelFile)this.existingBlock(this.blockLoc("electricfurnacerunning")), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacedouble), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacedouble)), (ModelFile)this.existingBlock(this.blockLoc("electricfurnacedoublerunning")), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacetriple), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacetriple)), (ModelFile)this.existingBlock(this.blockLoc("electricfurnacetriplerunning")), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnace), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnace)), (ModelFile)this.existingBlock(this.blockLoc("electricarcfurnacerunning")), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacedouble), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacedouble)), (ModelFile)this.existingBlock(this.blockLoc("electricarcfurnacedoublerunning")), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacetriple), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacetriple)), (ModelFile)this.existingBlock(this.blockLoc("electricarcfurnacetriplerunning")), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricpump), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricpump)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electrolyticseparator), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electrolyticseparator)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.energizedalloyer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.energizedalloyer)), (ModelFile)this.existingBlock(this.blockLoc("energizedalloyerrunning")), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fermentationplant), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fermentationplant)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidvoid), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidvoid)), true);
        this.horrRotatedBlock(ElectrodynamicsBlocks.BLOCK_FRAME, (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_FRAME.get()), true);
        this.simpleBlock(ElectrodynamicsBlocks.BLOCK_FRAME_CORNER, (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_FRAME_CORNER.get()), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.hydroelectricgenerator), (ModelFile)this.existingBlock(this.blockLoc("hydroelectricgeneratorengine")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.lathe), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.lathe)), true);
        this.wire((Block)ElectrodynamicsBlocks.BLOCK_LOGISTICALMANAGER.get(), (ModelFile)this.existingBlock(this.blockLoc("logisticalmanager_none")), (ModelFile)this.existingBlock(this.blockLoc("logisticalmanager_inventory")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralcrusher), (ModelFile)this.existingBlock(this.blockLoc("mineralcrusherbase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralcrusherdouble), (ModelFile)this.existingBlock(this.blockLoc("mineralcrusherdoublebase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralcrushertriple), (ModelFile)this.existingBlock(this.blockLoc("mineralcrushertriplebase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralgrinder), (ModelFile)this.existingBlock(this.blockLoc("mineralgrinderbase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralgrinderdouble), (ModelFile)this.existingBlock(this.blockLoc("mineralgrinderdoublebase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralgrindertriple), (ModelFile)this.existingBlock(this.blockLoc("mineralgrindertriplebase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralwasher), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralwasher)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.motorcomplex), (ModelFile)this.existingBlock(this.blockLoc("motorcomplexbase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.multimeterblock), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.multimeterblock)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.oxidationfurnace), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.oxidationfurnace)), (ModelFile)this.existingBlock(this.blockLoc("oxidationfurnacerunning")), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.quarry), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.quarry)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.reinforcedalloyer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.reinforcedalloyer)), (ModelFile)this.existingBlock(this.blockLoc("reinforcedalloyerrunning")), true);
        this.simpleBlock(ElectrodynamicsBlocks.BLOCK_SEISMICMARKER, (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_SEISMICMARKER.get()), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.seismicrelay), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.seismicrelay)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.solarpanel), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.solarpanel)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tanksteel), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tanksteel)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tankreinforced), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tankreinforced)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tankhsla), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.tankhsla)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.thermoelectricgenerator), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.thermoelectricgenerator)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.windmill), (ModelFile)this.existingBlock(this.blockLoc("windmillbase")), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremill), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremill)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilldouble), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilldouble)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilltriple), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilltriple)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastanksteel), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastanksteel)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastankreinforced), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastankreinforced)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastankhsla), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gastankhsla)), true);
        this.horrRotatedBlock(ElectrodynamicsBlocks.BLOCK_ADVANCEDCOMPRESSOR, (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_ADVANCEDCOMPRESSOR.get()), 180, 0, false);
        this.horrRotatedBlock(ElectrodynamicsBlocks.BLOCK_ADVANCEDDECOMPRESSOR, (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_ADVANCEDDECOMPRESSOR.get()), 180, 0, false);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get()).partialState().with(ElectrodynamicsBlockStates.ADDONTANK_NEIGHBOR_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.AddonTankNeighborType.BOTTOMANDTOPTANK)).modelForState().modelFile((ModelFile)this.existingBlock(this.blockLoc("compressoraddontanktab"))).addModel()).partialState().with(ElectrodynamicsBlockStates.ADDONTANK_NEIGHBOR_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.AddonTankNeighborType.TOPTANK)).modelForState().modelFile((ModelFile)this.existingBlock(this.blockLoc("compressoraddontankt"))).addModel()).partialState().with(ElectrodynamicsBlockStates.ADDONTANK_NEIGHBOR_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.AddonTankNeighborType.BOTTOMTANK)).modelForState().modelFile((ModelFile)this.existingBlock(this.blockLoc("compressoraddontankb"))).addModel()).partialState().with(ElectrodynamicsBlockStates.ADDONTANK_NEIGHBOR_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.AddonTankNeighborType.NONE)).modelForState().modelFile((ModelFile)this.existingBlock(ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK)).addModel();
        this.blockItem((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get(), (ModelFile)this.existingBlock(ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK));
        ModelFile.ExistingModelFile none = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_SIDE.get());
        ModelFile.ExistingModelFile top = this.existingBlock(this.blockLoc("compressorsidet"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_SIDE.get()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(270).addModel();
        this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gasvent), this.blockLoc("gasvent"), true);
        ModelFile.ExistingModelFile off = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_ADVANCED_THERMOELECTRICMANIPULATOR.get());
        ModelFile.ExistingModelFile existingModelFile = this.existingBlock(this.blockLoc("advancedthermoelectricmanipulatorcool"));
        ModelFile.ExistingModelFile heat = this.existingBlock(this.blockLoc("advancedthermoelectricmanipulatorheat"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_ADVANCED_THERMOELECTRICMANIPULATOR.get()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).modelForState().modelFile((ModelFile)off).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).modelForState().modelFile((ModelFile)off).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).modelForState().modelFile((ModelFile)off).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).modelForState().modelFile((ModelFile)off).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).modelForState().modelFile((ModelFile)existingModelFile).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).modelForState().modelFile((ModelFile)existingModelFile).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).modelForState().modelFile((ModelFile)existingModelFile).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).modelForState().modelFile((ModelFile)existingModelFile).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).modelForState().modelFile((ModelFile)heat).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).modelForState().modelFile((ModelFile)heat).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).modelForState().modelFile((ModelFile)heat).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).modelForState().modelFile((ModelFile)heat).rotationY(0).addModel();
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gasvalve), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gasvalve)), (ModelFile)this.existingBlock(this.blockLoc("gasvalveon")), 90, 0, true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidvalve), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidvalve)), (ModelFile)this.existingBlock(this.blockLoc("fluidvalveon")), 90, 0, true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gaspipepump), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gaspipepump)), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidpipepump), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidpipepump)), false);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gaspipefilter), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.gaspipefilter)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidpipefilter), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.fluidpipefilter)), true);
        this.horrRotatedLitBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.relay), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.relay)), (ModelFile)this.existingBlock(this.blockLoc("relayon")), 180, 0, true);
        this.glassBlock(ElectrodynamicsBlocks.BLOCK_STEELSCAFFOLDING, this.blockLoc("steelscaffold"), true);
        this.simpleBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.potentiometer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.potentiometer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.advanceddowngradetransformer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.advanceddowngradetransformer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.advancedupgradetransformer), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.advancedupgradetransformer)), true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.circuitmonitor), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.circuitmonitor)), 90, 0, true);
        this.horrRotatedBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.currentregulator), (ModelFile)this.existingBlock((Block)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.currentregulator)), 180, 0, true);
        none = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR.get());
        top = this.existingBlock(this.blockLoc("compressortoptank"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR.get()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(270).addModel();
        this.blockItem((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR.get(), (ModelFile)this.existingBlock(ElectrodynamicsBlocks.BLOCK_COMPRESSOR));
        none = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_DECOMPRESSOR.get());
        top = this.existingBlock(this.blockLoc("decompressortoptank"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_DECOMPRESSOR.get()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)none).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)top).rotationY(270).addModel();
        this.blockItem((Block)ElectrodynamicsBlocks.BLOCK_DECOMPRESSOR.get(), (ModelFile)this.existingBlock(ElectrodynamicsBlocks.BLOCK_DECOMPRESSOR));
        off = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get());
        ModelFile.ExistingModelFile existingModelFile2 = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get());
        heat = this.existingBlock((Block)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get());
        ModelFile.ExistingModelFile offtop = this.existingBlock(this.blockLoc("thermoelectricmanipulatortoptank"));
        ModelFile.ExistingModelFile cooltop = this.existingBlock(this.blockLoc("thermoelectricmanipulatortoptank"));
        ModelFile.ExistingModelFile heattop = this.existingBlock(this.blockLoc("thermoelectricmanipulatortoptank"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)off).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)off).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)off).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)off).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)existingModelFile2).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)existingModelFile2).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)existingModelFile2).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)existingModelFile2).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)heat).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)heat).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)heat).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)heat).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)offtop).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)offtop).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)offtop).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)offtop).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)cooltop).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)cooltop).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)cooltop).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)cooltop).rotationY(270).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)heattop).rotationY(0).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)heattop).rotationY(90).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)heattop).rotationY(180).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT)).with((Property)ElectrodynamicsBlockStates.COMPRESSORSIDE_HAS_TOPTANK, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)heattop).rotationY(270).addModel();
        this.blockItem((Block)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get(), (ModelFile)this.existingBlock(ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR));
        this.genWires();
        this.genFluidPipes();
        this.genGasPipes();
    }

    private void genWires() {
        String parent = "parent/";
        String name = "block/wire/";
        String texture = "wire/";
        for (SubtypeWire wire : DataGenerators.getWires(SubtypeWire.WireMaterial.values(), SubtypeWire.InsulationMaterial.BARE, SubtypeWire.WireClass.BARE, SubtypeWire.WireColor.NONE)) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_WIRE.getValue((Object)wire), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_none", this.modLoc(parent + "wire_none"))).texture("conductor", this.blockLoc(texture + wire.getWireMaterial().toString()))).texture("particle", "#conductor")).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_side", this.modLoc(parent + "wire_side"))).texture("conductor", this.blockLoc(texture + wire.getWireMaterial().toString()))).texture("particle", "#conductor")).renderType("cutout"), false);
        }
        for (SubtypeWire wire : DataGenerators.getWires(SubtypeWire.WireMaterial.values(), SubtypeWire.InsulationMaterial.WOOL, SubtypeWire.WireClass.INSULATED, SubtypeWire.WireColor.values())) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_WIRE.getValue((Object)wire), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_none", this.modLoc(parent + "insulatedwire_none"))).texture("conductor", this.blockLoc(texture + wire.getWireMaterial().toString() + "_center"))).texture("insulation", this.blockLoc(texture + "insulationwool_center"))).texture("particle", "#insulation")).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_side", this.modLoc(parent + "insulatedwire_side"))).texture("insulation", this.blockLoc(texture + "insulationwool"))).texture("particle", "#insulation")).renderType("cutout"), false);
        }
        for (SubtypeWire wire : DataGenerators.getWires(SubtypeWire.WireMaterial.values(), SubtypeWire.InsulationMaterial.WOOL, SubtypeWire.WireClass.LOGISTICAL, SubtypeWire.WireColor.values())) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_WIRE.getValue((Object)wire), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_none", this.modLoc(parent + "logisticswire_none"))).texture("conductor", this.blockLoc(texture + "logisticswire" + wire.getWireMaterial().toString()))).texture("insulation", this.blockLoc(texture + "logisticswireinsulation_center"))).texture("particle", "#insulation")).texture("redstone", this.blockLoc(texture + "logisticswireredstone_center"))).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_side", this.modLoc(parent + "logisticswire_side"))).texture("insulation", this.blockLoc(texture + "logisticswireinsulation_side"))).texture("particle", "#insulation")).texture("redstone", this.blockLoc(texture + "logisticswireredstone_side"))).renderType("cutout"), false);
        }
        for (SubtypeWire wire : DataGenerators.getWires(SubtypeWire.WireMaterial.values(), SubtypeWire.InsulationMaterial.CERAMIC, SubtypeWire.WireClass.CERAMIC, SubtypeWire.WireColor.values())) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_WIRE.getValue((Object)wire), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_none", this.modLoc(parent + "ceramicinsulatedwire_none"))).texture("conductor", this.blockLoc(texture + wire.getWireMaterial().toString() + "_center"))).texture("insulation", this.blockLoc(texture + "insulationceramic_center_base"))).texture("particle", "#insulation")).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_side", this.modLoc(parent + "ceramicinsulatedwire_side"))).texture("insulationbase", this.blockLoc(texture + "insulationceramic_base"))).texture("insulationcolor", this.blockLoc(texture + "insulationceramic"))).texture("particle", "#insulationcolor")).renderType("cutout"), false);
        }
        for (SubtypeWire wire : DataGenerators.getWires(SubtypeWire.WireMaterial.values(), SubtypeWire.InsulationMaterial.THICK_WOOL, SubtypeWire.WireClass.THICK, SubtypeWire.WireColor.values())) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_WIRE.getValue((Object)wire), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_none", this.modLoc(parent + "highlyinsulatedwire_none"))).texture("conductor", this.blockLoc(texture + wire.getWireMaterial().toString() + "_center"))).texture("insulation", this.blockLoc(texture + "insulationwool_center"))).texture("particle", "#insulation")).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + wire.tag() + "_side", this.modLoc(parent + "highlyinsulatedwire_side"))).texture("insulation", this.blockLoc(texture + "insulationwool"))).texture("particle", "#insulation")).renderType("cutout"), false);
        }
    }

    private void genFluidPipes() {
        String parent = "parent/";
        String name = "block/pipe/";
        String texture = "pipe/";
        for (SubtypeFluidPipe pipe : SubtypeFluidPipe.values()) {
            this.wire((Block)ElectrodynamicsBlocks.BLOCKS_FLUIDPIPE.getValue((Object)pipe), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "_none", this.modLoc(parent + "pipe_none"))).texture("texture", this.blockLoc(texture + pipe.tag()))).texture("particle", "#texture"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "_side", this.modLoc(parent + "pipe_side"))).texture("texture", this.blockLoc(texture + pipe.tag()))).texture("particle", "#texture"), false);
        }
    }

    private void genGasPipes() {
        this.gasPipeUninsulated(SubtypeGasPipe.UNINSULATEDCOPPER);
        this.gasPipeUninsulated(SubtypeGasPipe.UNINSULATEDSTEEL);
        this.gasPipeUninsulatedPlastic(SubtypeGasPipe.UNINSULATEDPLASTIC);
    }

    private void gasPipeUninsulated(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "center", this.modLoc(parent + "uninsulatedcenter"))).texture("texture", this.blockLoc(texture + pipe.tag() + "center"))).texture("particle", "#texture"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "uninsulatedside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }

    private void gasPipeUninsulatedPlastic(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "center", this.modLoc(parent + "uninsulatedcenter"))).texture("texture", this.blockLoc(texture + pipe.tag() + "center"))).texture("particle", "#texture"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "uninsulatedplasticside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }

    private void gasPipeWoolInsulated(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)this.models().getExistingFile(this.modLoc(parent + "woolinsulatedcenter")), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "insulatedside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }

    private void gasPipeWoolInsulatedPlastic(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)this.models().getExistingFile(this.modLoc(parent + "woolinsulatedcenter")), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "insulatedplasticside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }

    private void gasPipeCeramicInsulated(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)this.models().getExistingFile(this.modLoc(parent + "ceramicinsulatedcenter")), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "insulatedside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }

    private void gasPipeCeramicInsulatedPlastic(SubtypeGasPipe pipe) {
        String parent = "parent/gaspipe";
        String name = "block/gaspipe/";
        String texture = "gaspipe/";
        this.wire((Block)ElectrodynamicsBlocks.BLOCKS_GASPIPE.getValue((Object)pipe), (ModelFile)this.models().getExistingFile(this.modLoc(parent + "ceramicinsulatedcenter")), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + pipe.tag() + "side", this.modLoc(parent + "insulatedplasticside"))).texture("texture", this.blockLoc(texture + pipe.tag() + "side"))).texture("particle", "#texture"), false);
    }
}

