/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.compatibility.jei.recipecategories.thermomanipulator;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoFluid2GasRecipe;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.GasStack;
import voltaic.api.screen.ITexture;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.JeiTextures;
import voltaic.compatibility.jei.utils.gui.ScreenObject;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.compatibility.jei.utils.gui.types.fluidgauge.AbstractFluidGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.fluidgauge.FluidGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.AbstractGasGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.GasGaugeObject;
import voltaic.compatibility.jei.utils.label.AbstractLabelWrapper;
import voltaic.compatibility.jei.utils.label.types.PowerLabelWrapperConstant;
import voltaic.prefab.utilities.math.Color;

public class EvaporatingFluidRecipeCategory
extends AbstractRecipeCategory<PsuedoFluid2GasRecipe> {
    private static final BackgroundObject BACK_WRAP = new BackgroundObject(132, 70);
    private static final ScreenObject CONDENSER_COLUMN = new ScreenObject((ITexture)ITexture.Textures.CONDENSER_COLUMN, 50, 6);
    private static final FluidGaugeObject IN_FLUID_GAUGE = new FluidGaugeObject(10, 5);
    private static final ScreenObject OUT_FLUID_GAUGE = new ScreenObject((ITexture)JeiTextures.FLUID_GAUGE_DEFAULT, 88, 5);
    private static final ScreenObject IN_GAS_GAUGE = new ScreenObject((ITexture)JeiTextures.FAKE_GAS_GAUGE, 30, 5);
    private static final GasGaugeObject OUT_GAS_GAUGE = new GasGaugeObject(108, 5);
    private static final PowerLabelWrapperConstant POWER_LABEL = new PowerLabelWrapperConstant(2, 60, ElectroConstants.THERMOELECTRIC_MANIPULATOR_USAGE_PER_TICK, 120);
    private static final AbstractLabelWrapper TEMPERATURE_LABEL = new AbstractLabelWrapper(Color.JEI_TEXT_GRAY, 60, 130, true){

        public Component getComponent(AbstractRecipeCategory<?> category, Object recipe) {
            PsuedoFluid2GasRecipe psuedo = (PsuedoFluid2GasRecipe)recipe;
            return Component.m_237113_((String)"> ").m_7220_((Component)ChatFormatter.getChatDisplayShort((double)psuedo.output.getTemperature(), (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN));
        }
    };
    private static final int ANIM_TIME = 50;
    public static final String RECIPE_GROUP = "gas_evaporating";
    public static ItemStack INPUT_MACHINE = new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get());
    public static final RecipeType<PsuedoFluid2GasRecipe> RECIPE_TYPE = RecipeType.create((String)"electrodynamics", (String)"gas_evaporating", PsuedoFluid2GasRecipe.class);

    public EvaporatingFluidRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Component)ElectroTextUtils.jeiTranslated(RECIPE_GROUP, new Object[0]), INPUT_MACHINE, BACK_WRAP, RECIPE_TYPE, 50);
        this.setFluidInputs(guiHelper, new AbstractFluidGaugeObject[]{IN_FLUID_GAUGE});
        this.setGasOutputs(guiHelper, new AbstractGasGaugeObject[]{OUT_GAS_GAUGE});
        this.setScreenObjects(guiHelper, new ScreenObject[]{IN_GAS_GAUGE, OUT_FLUID_GAUGE, CONDENSER_COLUMN});
        this.setLabels(new AbstractLabelWrapper[]{POWER_LABEL, TEMPERATURE_LABEL});
    }

    public List<List<FluidStack>> getFluidInputs(PsuedoFluid2GasRecipe recipe) {
        ArrayList gases = new ArrayList();
        for (FluidIngredient ing : recipe.inputs) {
            gases.addAll(ing.getMatchingFluids());
        }
        return Arrays.asList(gases);
    }

    public List<GasStack> getGasOutputs(PsuedoFluid2GasRecipe recipe) {
        return Arrays.asList(recipe.output);
    }

    public List<List<ItemStack>> getItemInputs(PsuedoFluid2GasRecipe recipe) {
        if (recipe.inputBucket.m_41619_()) {
            return Collections.emptyList();
        }
        return Arrays.asList(Arrays.asList(recipe.inputBucket));
    }

    public List<ItemStack> getItemOutputs(PsuedoFluid2GasRecipe recipe) {
        if (recipe.outputCylinder.m_41619_()) {
            return Collections.emptyList();
        }
        return Arrays.asList(recipe.outputCylinder);
    }
}

