/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.GenericTileGasTransformer;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IAddonTankManager;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IMultiblockGasTransformer;
import electrodynamics.common.tile.pipelines.gas.gastransformer.TileGasTransformerAddonTank;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicCapabilities;

public class TileGasTransformerSideBlock
extends GenericTile
implements IAddonTankManager {
    private BlockPos ownerPos = BlockEntityUtils.OUT_OF_REACH;
    private boolean isLeft = false;

    public TileGasTransformerSideBlock(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_COMPRESSOR_SIDE.get(), worldPos, blockState);
    }

    public void setOwnerPos(BlockPos ownerPos) {
        this.ownerPos = ownerPos;
    }

    public void setIsLeft() {
        this.isLeft = true;
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateTankCount();
    }

    @Override
    public void updateTankCount() {
        BlockEntity aboveTile;
        BlockPos abovePos = this.m_58899_().m_7494_();
        BlockState aboveState = this.m_58904_().m_8055_(abovePos);
        int tankCount = 0;
        for (int i = 0; i < ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_LIMIT && aboveState.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get()) && (aboveTile = this.m_58904_().m_7702_(abovePos)) != null && aboveTile instanceof TileGasTransformerAddonTank; ++i) {
            TileGasTransformerAddonTank tank = (TileGasTransformerAddonTank)aboveTile;
            abovePos = abovePos.m_7494_();
            aboveState = this.m_58904_().m_8055_(abovePos);
            tank.setOwnerPos(this.m_58899_());
            ++tankCount;
        }
        BlockEntity owner = this.m_58904_().m_7702_(this.ownerPos);
        if (owner != null && owner instanceof IMultiblockGasTransformer) {
            IMultiblockGasTransformer compressor = (IMultiblockGasTransformer)owner;
            compressor.updateAddonTanks(tankCount, this.isLeft);
        }
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.ownerPos);
        if (blockEntity instanceof IMultiblockGasTransformer) {
            IMultiblockGasTransformer compressor = (IMultiblockGasTransformer)blockEntity;
            this.m_58904_().m_46961_(this.ownerPos, !compressor.hasBeenDestroyed());
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("owner", (Tag)NbtUtils.m_129224_((BlockPos)this.ownerPos));
        compound.m_128379_("isleft", this.isLeft);
    }

    public void m_142466_(CompoundTag compound) {
        BlockPos optional;
        super.m_142466_(compound);
        this.ownerPos = optional = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("owner"));
        this.isLeft = compound.m_128471_("isleft");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        GenericTileGasTransformer compressor;
        BlockEntity blockEntity;
        if (side == null || this.ownerPos == null) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && (blockEntity = this.m_58904_().m_7702_(this.ownerPos)) instanceof GenericTileGasTransformer && (compressor = (GenericTileGasTransformer)blockEntity).hasComponent(IComponentType.FluidHandler)) {
            if (this.isLeft) {
                return ((IComponentFluidHandler)compressor.getComponent(IComponentType.FluidHandler)).getCapability(cap, side, CapabilityInputType.INPUT);
            }
            return ((IComponentFluidHandler)compressor.getComponent(IComponentType.FluidHandler)).getCapability(cap, side, CapabilityInputType.OUTPUT);
        }
        if (cap == VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK && (blockEntity = this.m_58904_().m_7702_(this.ownerPos)) instanceof GenericTileGasTransformer) {
            compressor = (GenericTileGasTransformer)blockEntity;
            return compressor.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.ownerPos);
        if (blockEntity instanceof GenericTileGasTransformer) {
            GenericTileGasTransformer compressor = (GenericTileGasTransformer)blockEntity;
            return compressor.use(player, hand, hit);
        }
        return super.use(player, hand, hit);
    }
}

