/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCoolantResavoir;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericMaterialTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileCoolantResavoir
extends GenericMaterialTile {
    public TileCoolantResavoir(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_COOLANTRESAVOIR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(ElectroConstants.QUARRY_WATERUSAGE_PER_BLOCK * 1000, (GenericTile)this, "tank").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.BACK, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setValidFluidTags(new TagKey[]{FluidTags.f_13131_}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1)).valid(TileCoolantResavoir.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.coolantresavoir.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCoolantResavoir((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        FluidUtilities.drainItem((GenericTile)this, (FluidTank[])((ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler)).toArray());
    }

    public boolean hasEnoughFluid(int fluidAmnt) {
        ComponentFluidHandlerSimple simple = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        return !simple.isEmpty() && simple.getFluidAmount() >= fluidAmnt;
    }

    public void drainFluid(int fluidAmnt) {
        ComponentFluidHandlerSimple simple = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        simple.drain(fluidAmnt, IFluidHandler.FluidAction.EXECUTE);
    }

    public int getComparatorSignal() {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        return (int)((double)handler.getFluidAmount() / (double)Math.max(1, handler.getCapacity()) * 15.0);
    }
}

