/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerSolarPanel;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.GenericGeneratorTile;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileSolarPanel
extends GenericGeneratorTile {
    protected CachedTileOutput output;
    protected SingleProperty<Boolean> generating = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "generating", (Object)false));
    protected SingleProperty<Double> multiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)1.0));
    protected SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));

    public TileSolarPanel(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_SOLARPANEL.get(), worldPosition, blockState, 2.25, SubtypeItemUpgrade.improvedsolarcell);
    }

    public TileSolarPanel(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, double multiplier, SubtypeItemUpgrade ... itemUpgrades) {
        super(type, worldPosition, blockState, multiplier, itemUpgrades);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().upgrades(1)).validUpgrades(ContainerSolarPanel.VALID_UPGRADES).valid(TileSolarPanel.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.solarpanel.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerSolarPanel((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.generating.setValue((Object)false);
            return;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.f_58858_.m_121945_(Direction.DOWN));
            this.generating.setValue((Object)this.f_58857_.m_45527_(this.f_58858_.m_7918_(0, 1, 0)));
        }
        if (this.f_58857_.m_46461_() && ((Boolean)this.generating.getValue()).booleanValue() && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), Direction.UP, this.getProduced(), false);
        }
    }

    public TransferPack getProduced() {
        double mod = 1.0f - Mth.m_14036_((float)(1.0f - (Mth.m_14089_((float)(this.f_58857_.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.2f)), (float)0.0f, (float)1.0f);
        double temp = ((Biome)this.f_58857_.m_7062_().m_204214_(this.m_58899_()).m_203334_()).m_47554_();
        double lerped = Mth.m_14139_((double)((temp + 1.0) / 3.0), (double)1.5, (double)3.0) / 3.0;
        return TransferPack.ampsVoltage((double)(this.getMultiplier() * ElectroConstants.SOLARPANEL_AMPERAGE * lerped * mod * (double)(this.f_58857_.m_46471_() || this.f_58857_.m_46470_() ? 0.8f : 1.0f)), (double)((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getVoltage());
    }

    public double getMultiplier() {
        return (Double)this.multiplier.getValue();
    }

    public void setMultiplier(double val) {
        this.multiplier.setValue((Object)val);
    }

    public int getComparatorSignal() {
        return (Boolean)this.generating.getValue() != false ? 15 : 0;
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

