/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.network.type;

import com.mojang.datafixers.util.Pair;
import electrodynamics.common.tile.pipelines.gas.GenericTileGasPipe;
import electrodynamics.common.tile.pipelines.gas.TileGasPipePump;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.network.ITickableNetwork;
import voltaic.api.network.cable.type.IGasPipe;
import voltaic.common.network.NetworkRegistry;
import voltaic.common.network.utils.GasUtilities;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.network.AbstractNetwork;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;
import voltaic.prefab.utilities.Scheduler;

public class GasNetwork
extends AbstractNetwork<GenericTileGasPipe, IGasPipe, GasStack, GasNetwork> {
    public int maxPressure = 0;
    public double pressureOfTransmitted = 0.0;
    public double temperatureOfTransmitted = 0.0;
    public ConcurrentHashMap<Integer, HashSet<TileGasPipePump>> priorityPumpMap = new ConcurrentHashMap();
    private final HashMap<Integer, HashSet<GenericTileGasPipe>> pressureToGasPipeMap = new HashMap();
    private final HashSet<GenericTileGasPipe> destroyedByCorrosion = new HashSet();

    public GasNetwork(Collection<GenericTileGasPipe> pipes) {
        this.conductorSet.addAll(pipes);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public GasNetwork(Set<GasNetwork> networks) {
        for (GasNetwork network : networks) {
            if (network == null) continue;
            this.conductorSet.addAll(network.conductorSet);
            network.deregister();
        }
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public void refreshNewNetwork() {
        this.priorityPumpMap.clear();
        this.maxPressure = 0;
        this.networkMaxTransfer = 0.0;
        this.pressureToGasPipeMap.clear();
        this.destroyedByCorrosion.clear();
        super.refreshNewNetwork();
    }

    public GasStack emit(GasStack inserted, ArrayList<BlockEntity> ignored, boolean debug) {
        GasStack transfer = new GasStack(inserted.getGas(), Math.min(inserted.getAmount(), (int)this.networkMaxTransfer), inserted.getTemperature(), inserted.getPressure());
        if (transfer.getAmount() <= 0 || ignored.isEmpty()) {
            return GasStack.EMPTY;
        }
        if (this.checkForOverloadAndHandle(transfer, !debug)) {
            return transfer;
        }
        GasStack copy = transfer.copy();
        GasStack taken = new GasStack(transfer.getGas(), 0, transfer.getTemperature(), transfer.getPressure());
        Pair<GasStack, Set<TileGasPipePump>> priorityTaken = this.emitToPumps(transfer, ignored);
        copy.shrink(((GasStack)priorityTaken.getFirst()).getAmount());
        taken.grow(((GasStack)priorityTaken.getFirst()).getAmount());
        if (copy.isEmpty()) {
            return taken;
        }
        ConcurrentHashMap.KeySetView recievingTiles = ConcurrentHashMap.newKeySet();
        recievingTiles.addAll(this.acceptorSet);
        recievingTiles.removeAll(ignored);
        recievingTiles.removeAll((Collection)priorityTaken.getSecond());
        if (recievingTiles.isEmpty()) {
            return GasStack.EMPTY;
        }
        int size = recievingTiles.size();
        for (BlockEntity tile : recievingTiles) {
            if (tile == null || tile.m_58901_()) {
                this.acceptorInputMap.remove(tile);
                this.acceptorSet.remove(tile);
                continue;
            }
            GasStack gasPerTile = new GasStack(copy.getGas(), copy.getAmount() / size, copy.getTemperature(), copy.getPressure());
            GasStack preGasPerTile = gasPerTile.copy();
            HashSet connections = this.acceptorInputMap.getOrDefault(tile, new HashSet());
            int connectionCount = connections.size();
            for (Direction dir : connections) {
                GasStack gasPerConnection = new GasStack(gasPerTile.getGas(), gasPerTile.getAmount() / connectionCount, gasPerTile.getTemperature(), gasPerTile.getPressure());
                GasStack preGasPerConnection = gasPerConnection.copy();
                int amtTaken = GasUtilities.recieveGas((BlockEntity)tile, (Direction)dir, (GasStack)gasPerConnection, (GasAction)GasAction.EXECUTE);
                gasPerConnection.shrink(amtTaken);
                gasPerTile.shrink(preGasPerConnection.getAmount() - gasPerConnection.getAmount());
                --connectionCount;
            }
            int takenAmt = preGasPerTile.getAmount() - gasPerTile.getAmount();
            copy.shrink(takenAmt);
            taken.setAmount(taken.getAmount() + takenAmt);
            --size;
        }
        this.transmittedThisTick = taken.getAmount();
        this.temperatureOfTransmitted = taken.getTemperature();
        this.pressureOfTransmitted = taken.getPressure();
        return taken;
    }

    private Pair<GasStack, Set<TileGasPipePump>> emitToPumps(GasStack transfer, ArrayList<BlockEntity> ignored) {
        GasStack taken = new GasStack(transfer.getGas(), 0, transfer.getTemperature(), transfer.getPressure());
        ConcurrentHashMap.KeySetView acceptedPumps = ConcurrentHashMap.newKeySet();
        if (this.priorityPumpMap.isEmpty()) {
            return Pair.of((Object)taken, acceptedPumps);
        }
        GasStack copy = transfer.copy();
        for (int i = 9; i >= 0; --i) {
            if (copy.isEmpty()) {
                return Pair.of((Object)taken, acceptedPumps);
            }
            Set prioritySet = this.priorityPumpMap.getOrDefault(i, new HashSet());
            if (prioritySet.isEmpty()) continue;
            Pair<GasStack, Set<TileGasPipePump>> accepted = this.emitToPumpSet(copy, prioritySet, ignored);
            acceptedPumps.addAll((Collection)accepted.getSecond());
            taken.grow(((GasStack)accepted.getFirst()).getAmount());
            copy.shrink(((GasStack)accepted.getFirst()).getAmount());
        }
        return Pair.of((Object)taken, acceptedPumps);
    }

    private Pair<GasStack, Set<TileGasPipePump>> emitToPumpSet(GasStack transfer, Set<TileGasPipePump> recievingTiles, ArrayList<BlockEntity> ignored) {
        GasStack copy = transfer.copy();
        GasStack taken = new GasStack(transfer.getGas(), 0, transfer.getTemperature(), transfer.getPressure());
        ConcurrentHashMap.KeySetView filledPumps = ConcurrentHashMap.newKeySet();
        int size = recievingTiles.size();
        for (TileGasPipePump tile : recievingTiles) {
            if (!tile.isPowered() || ignored.contains((Object)tile)) {
                --size;
                continue;
            }
            GasStack gasPerTile = new GasStack(copy.getGas(), copy.getAmount() / size, copy.getTemperature(), copy.getPressure());
            GasStack preGasPerTile = gasPerTile.copy();
            HashSet connections = this.acceptorInputMap.getOrDefault((Object)tile, new HashSet());
            int connectionCount = connections.size();
            for (Direction dir : connections) {
                GasStack gasPerConnection = new GasStack(gasPerTile.getGas(), gasPerTile.getAmount() / connectionCount, gasPerTile.getTemperature(), gasPerTile.getPressure());
                GasStack preGasPerConnection = gasPerConnection.copy();
                int amtTaken = GasUtilities.recieveGas((BlockEntity)tile, (Direction)dir, (GasStack)gasPerConnection, (GasAction)GasAction.EXECUTE);
                gasPerConnection.shrink(amtTaken);
                gasPerTile.shrink(preGasPerConnection.getAmount() - gasPerConnection.getAmount());
                --connectionCount;
            }
            int takenAmt = preGasPerTile.getAmount() - gasPerTile.getAmount();
            copy.shrink(takenAmt);
            taken.setAmount(taken.getAmount() + takenAmt);
            if (takenAmt > 0) {
                filledPumps.add(tile);
            }
            filledPumps.add(tile);
            --size;
        }
        this.transmittedThisTick = taken.getAmount();
        this.temperatureOfTransmitted = taken.getTemperature();
        this.pressureOfTransmitted = taken.getPressure();
        return Pair.of((Object)taken, filledPumps);
    }

    private boolean checkForOverloadAndHandle(GasStack stack, boolean live) {
        boolean isCorrosive = stack.is(VoltaicTags.Gases.IS_CORROSIVE);
        if (stack.getPressure() <= this.maxPressure && !isCorrosive) {
            return false;
        }
        HashSet<GenericTileGasPipe> overloadedPipes = new HashSet<GenericTileGasPipe>();
        for (Map.Entry<Integer, HashSet<GenericTileGasPipe>> entry : this.pressureToGasPipeMap.entrySet()) {
            if (entry.getKey() >= stack.getPressure()) continue;
            overloadedPipes.addAll((Collection)entry.getValue());
        }
        if (isCorrosive) {
            overloadedPipes.addAll(this.destroyedByCorrosion);
        }
        if (overloadedPipes.isEmpty()) {
            return false;
        }
        if (!live) {
            return true;
        }
        for (GenericTileGasPipe pipe : overloadedPipes) {
            Scheduler.schedule((int)1, pipe::destroyViolently);
        }
        return true;
    }

    public void updateConductorStatistics(GenericTileGasPipe cable, boolean remove) {
        super.updateConductorStatistics((GenericRefreshingConnectTile)cable, remove);
        if (remove) {
            int pressure = ((IGasPipe)cable.getCableType()).getPipeMaterial().getMaxPressuire();
            if (this.pressureToGasPipeMap.containsKey(pressure)) {
                HashSet<GenericTileGasPipe> set = this.pressureToGasPipeMap.get(pressure);
                set.remove((Object)cable);
                this.pressureToGasPipeMap.put(pressure, set);
            }
            this.destroyedByCorrosion.remove((Object)cable);
        } else {
            IGasPipe pipe = (IGasPipe)cable.getCableType();
            if (this.networkMaxTransfer == 0.0 || this.networkMaxTransfer < (double)pipe.getMaxTransfer()) {
                this.networkMaxTransfer = pipe.getMaxTransfer();
            }
            if (this.maxPressure == 0 || pipe.getPipeMaterial().getMaxPressuire() < this.maxPressure) {
                this.maxPressure = pipe.getPipeMaterial().getMaxPressuire();
            }
            int pressure = pipe.getPipeMaterial().getMaxPressuire();
            HashSet<GenericTileGasPipe> set = this.pressureToGasPipeMap.getOrDefault(pressure, new HashSet());
            set.add(cable);
            this.pressureToGasPipeMap.put(pressure, set);
        }
    }

    public void updateRecieverStatistics(BlockEntity reciever, Direction dir) {
        if (reciever instanceof TileGasPipePump) {
            TileGasPipePump pump = (TileGasPipePump)reciever;
            int priority = (Integer)pump.priority.getValue();
            HashSet<TileGasPipePump> set = this.priorityPumpMap.getOrDefault(priority, new HashSet());
            set.add(pump);
            this.priorityPumpMap.put(priority, set);
        }
    }

    public void resetConductorStatistics() {
        this.networkMaxTransfer = 0.0;
        this.maxPressure = 0;
        this.pressureToGasPipeMap.clear();
        this.destroyedByCorrosion.clear();
        super.resetConductorStatistics();
    }

    public void resetReceiverStatistics() {
        this.priorityPumpMap.clear();
        super.resetReceiverStatistics();
    }

    public void updateGasPipePumpStats(TileGasPipePump changedPump, int newPriority, int prevPriority) {
        HashSet oldSet = this.priorityPumpMap.getOrDefault(prevPriority, new HashSet());
        oldSet.remove((Object)changedPump);
        this.priorityPumpMap.put(prevPriority, oldSet);
        HashSet<TileGasPipePump> newSet = this.priorityPumpMap.getOrDefault(newPriority, new HashSet());
        newSet.add(changedPump);
        this.priorityPumpMap.put(newPriority, newSet);
    }

    public void tick() {
        super.tick();
        this.pressureOfTransmitted = 0.0;
        this.temperatureOfTransmitted = 0.0;
        if (this.getSize() == 0) {
            this.deregister();
        }
    }

    public void deregister() {
        this.pressureToGasPipeMap.clear();
        super.deregister();
    }

    public boolean isConductor(BlockEntity tile, GenericTileGasPipe requesterCable) {
        return tile instanceof GenericTileGasPipe;
    }

    public GasNetwork createInstanceConductor(Set<GenericTileGasPipe> conductors) {
        return new GasNetwork((Collection<GenericTileGasPipe>)conductors);
    }
}

