/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric.utils;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemTemperate;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.item.TemperateItemProperties;

public class ItemRailgun
extends ItemElectric
implements IItemTemperate {
    private final TemperateItemProperties temperateProperties = new TemperateItemProperties();
    private double overheatTemperature = 0.0;
    private double tempThreshold = 0.0;
    private double tempPerTick = 0.0;

    public ItemRailgun(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab, double overheatTemperature, double tempThreshold, double tempPerTick, Function<Item, Item> getBatteryItem) {
        super(properties, creativeTab, getBatteryItem);
        this.overheatTemperature = overheatTemperature;
        this.tempThreshold = tempThreshold;
        this.tempPerTick = tempPerTick;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("railguntemp", ChatFormatter.getChatDisplayShort((double)IItemTemperate.getTemperature((ItemStack)stack), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS)).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)ElectroTextUtils.tooltip("railgunmaxtemp", ChatFormatter.getChatDisplayShort((double)this.overheatTemperature, (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS)).m_130940_(ChatFormatting.YELLOW));
        if (IItemTemperate.getTemperature((ItemStack)stack) >= this.getOverheatTemp()) {
            tooltip.add((Component)ElectroTextUtils.tooltip("railgunoverheat", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ArrayList superItems = new ArrayList();
        super.addCreativeModeItems(group, superItems);
        for (ItemStack stack : superItems) {
            if (!(stack.m_41720_() instanceof ItemRailgun)) continue;
            IItemTemperate.setTemperature((ItemStack)stack, (double)0.0);
        }
        items.addAll(superItems);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        ((ItemRailgun)stack.m_41720_()).loseHeat(stack, this.tempPerTick, 0.0, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public double getMaxTemp() {
        return this.overheatTemperature;
    }

    public double getOverheatTemp() {
        return this.overheatTemperature * this.tempThreshold;
    }

    public TemperateItemProperties getTemperteProperties() {
        return this.temperateProperties;
    }
}

