/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.model.armor.ModelHydraulicBoots;
import electrodynamics.common.item.gear.armor.ICustomArmor;
import electrodynamics.registers.ElectrodynamicsCreativeTabs;
import electrodynamics.registers.ElectrodynamicsFluids;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.fluid.RestrictedFluidHandlerItemStack;
import voltaic.common.item.gear.ItemVoltaicArmor;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemHydraulicBoots
extends ItemVoltaicArmor {
    public static final int MAX_CAPACITY = 2000;
    private static final String TEXTURE_LOCATION = "electrodynamics:textures/model/armor/hydraulicboots.png";

    public ItemHydraulicBoots() {
        super((ArmorMaterial)HydraulicBoots.HYDRAULIC_BOOTS, ArmorItem.Type.BOOTS, new Item.Properties().m_41487_(1), () -> (CreativeModeTab)ElectrodynamicsCreativeTabs.MAIN.get());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new RestrictedFluidHandlerItemStack(stack, 2000).setValidator(ItemHydraulicBoots.getPredicate());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                ModelHydraulicBoots model = new ModelHydraulicBoots(ElectrodynamicsClientRegister.HYDRAULIC_BOOTS.m_171564_());
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public void addCreativeModeItems(CreativeModeTab tab, List<ItemStack> items) {
        super.addCreativeModeItems(tab, items);
        if (ForgeCapabilities.FLUID_HANDLER_ITEM != null) {
            ItemStack full = new ItemStack((ItemLike)this);
            full.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> ((RestrictedFluidHandlerItemStack)h).setFluid(new FluidStack((Fluid)ElectrodynamicsFluids.FLUID_HYDRAULIC.get(), 2000)));
            items.add(full);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM != null) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)handler.getFluidInTank(0).getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)2000.0)).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return ItemHydraulicBoots.staticIsBarVisible(stack);
    }

    protected static boolean staticIsBarVisible(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(m -> {
            RestrictedFluidHandlerItemStack cap = (RestrictedFluidHandlerItemStack)m;
            return 13.0 * (double)cap.getFluidInTank(0).getAmount() / (double)cap.getTankCapacity(0) < 13.0;
        }).orElse(false);
    }

    public int m_142158_(ItemStack stack) {
        return ItemHydraulicBoots.staticGetBarWidth(stack);
    }

    protected static int staticGetBarWidth(ItemStack stack) {
        return (int)Math.round(stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            RestrictedFluidHandlerItemStack cap = (RestrictedFluidHandlerItemStack)h;
            return 13.0 * (double)cap.getFluidInTank(0).getAmount() / (double)cap.getTankCapacity(0);
        }).orElse(13.0));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return TEXTURE_LOCATION;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public static Predicate<FluidStack> getPredicate() {
        return fluid -> ForgeRegistries.FLUIDS.tags().getTag(VoltaicTags.Fluids.HYDRAULIC_FLUID).contains((Object)fluid.getFluid());
    }

    public static enum HydraulicBoots implements ICustomArmor
    {
        HYDRAULIC_BOOTS;


        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public String m_6082_() {
            return "electrodynamics:hydraulic_boots";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        public int m_266425_(ArmorItem.Type pType) {
            return 100;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return 1;
        }
    }
}

