/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.block;

import electrodynamics.common.tile.machines.quarry.TileLogisticalManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.common.block.connect.AbstractConnectBlock;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;
import voltaic.prefab.tile.types.IConnectTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class BlockLogisticalManager
extends GenericEntityBlockWaterloggable {
    protected final VoxelShape[] boundingBoxes = new VoxelShape[7];
    int maxValue = 64;
    protected VoxelShape[] shapestates = new VoxelShape[this.maxValue];

    public BlockLogisticalManager() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60955_().m_60999_());
        this.generateBoundingBoxes(3.0);
    }

    public void generateBoundingBoxes(double radius) {
        double w = radius;
        double sm = 8.0 - w;
        double lg = 8.0 + w;
        this.boundingBoxes[0] = Block.m_49796_((double)sm, (double)0.0, (double)sm, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[1] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)16.0, (double)lg);
        this.boundingBoxes[2] = Block.m_49796_((double)sm, (double)sm, (double)0.0, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[3] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)16.0);
        this.boundingBoxes[4] = Block.m_49796_((double)0.0, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[5] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)16.0, (double)lg, (double)lg);
        this.boundingBoxes[6] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity entity = level.m_7702_(pos);
        if (!(entity instanceof IConnectTile)) {
            return Shapes.m_83040_();
        }
        EnumConnectType[] connections = ((IConnectTile)entity).readConnections();
        int hash = AbstractConnectBlock.hashPresentSides((EnumConnectType[])connections);
        if (this.shapestates[hash] != null) {
            return this.shapestates[hash];
        }
        VoxelShape shape = this.boundingBoxes[6];
        for (int i = 0; i < 6; ++i) {
            if (connections[i] == EnumConnectType.NONE) continue;
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.boundingBoxes[i], (BooleanOp)BooleanOp.f_82695_);
        }
        this.shapestates[hash] = shape;
        if (shape == null) {
            return Shapes.m_83040_();
        }
        return shape;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileLogisticalManager(pos, state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void m_6807_(BlockState newState, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(newState, level, pos, oldState, isMoving);
        if (level.f_46443_) {
            return;
        }
        TileLogisticalManager tile = (TileLogisticalManager)level.m_7702_(pos);
        if (tile == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (TileLogisticalManager.isQuarry(pos.m_121945_(dir), (LevelReader)level)) {
                tile.writeConnection(dir, EnumConnectType.WIRE);
                continue;
            }
            if (!TileLogisticalManager.isValidInventory(pos.m_121945_(dir), (LevelReader)level, dir.m_122424_())) continue;
            tile.writeConnection(dir, EnumConnectType.INVENTORY);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
        TileLogisticalManager tile = (TileLogisticalManager)world.m_7702_(currentPos);
        EnumConnectType connection = EnumConnectType.NONE;
        if (tile == null) {
            return stateIn;
        }
        if (TileLogisticalManager.isQuarry(facingPos, (LevelReader)world)) {
            connection = EnumConnectType.WIRE;
        } else if (TileLogisticalManager.isValidInventory(facingPos, (LevelReader)world, facing.m_122424_())) {
            connection = EnumConnectType.INVENTORY;
        }
        tile.writeConnection(facing, connection);
        return stateIn;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world.m_5776_()) {
            return;
        }
        TileLogisticalManager tile = (TileLogisticalManager)world.m_7702_(pos);
        EnumConnectType connection = EnumConnectType.NONE;
        if (tile == null) {
            return;
        }
        Direction facing = BlockEntityUtils.directionFromPos((BlockPos)pos, (BlockPos)neighbor);
        if (TileLogisticalManager.isQuarry(neighbor, world)) {
            connection = EnumConnectType.WIRE;
        } else if (TileLogisticalManager.isValidInventory(neighbor, world, facing.m_122424_())) {
            connection = EnumConnectType.INVENTORY;
        }
        tile.writeConnection(facing, connection);
    }
}

