/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.common.item.subtype.SubtypeDrillHead;
import electrodynamics.prefab.utilities.object.QuarryArmDataHolder;
import java.util.HashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.event.AbstractLevelStageHandler;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;
import voltaic.prefab.utilities.math.PrecisionVector;

public class HandlerQuarryArm
extends AbstractLevelStageHandler {
    public static final HandlerQuarryArm INSTANCE = new HandlerQuarryArm();
    private final HashMap<BlockPos, QuarryArmDataHolder> armsToRender = new HashMap();

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS;
    }

    public void render(Camera camera, Frustum frustum, LevelRenderer renderer, PoseStack stack, Matrix4f projectionMatrix, Minecraft minecraft, int renderTick, float partialTick) {
        if (this.armsToRender.isEmpty()) {
            return;
        }
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        Vec3 camPos = camera.m_90583_();
        TextureAtlasSprite armTexture = ElectrodynamicsClientRegister.getSprite(ElectrodynamicsClientRegister.TEXTURE_QUARRYARM);
        float u0Frame = armTexture.m_118409_();
        float u1Frame = armTexture.m_118410_();
        float v0Frame = armTexture.m_118411_();
        float v1Frame = armTexture.m_118412_();
        Color colorFrame = new Color(armTexture.getPixelRGBA(0, 10, 10));
        TextureAtlasSprite darkArmTexture = ElectrodynamicsClientRegister.getSprite(ElectrodynamicsClientRegister.TEXTURE_QUARRYARM_DARK);
        float u0FrameDark = darkArmTexture.m_118409_();
        float u1FrameDark = darkArmTexture.m_118410_();
        float v0FrameDark = darkArmTexture.m_118411_();
        float v1FrameDark = darkArmTexture.m_118412_();
        Color colorFrameDark = new Color(armTexture.getPixelRGBA(0, 10, 10));
        TextureAtlasSprite titaniumTexture = (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(SubtypeDrillHead.titanium.blockTextureLoc);
        float u0Titanium = titaniumTexture.m_118409_();
        float u1Titanium = titaniumTexture.m_118410_();
        float v0Titanium = titaniumTexture.m_118411_();
        float v1Titanium = titaniumTexture.m_118412_();
        Color colorTitanium = new Color(armTexture.getPixelRGBA(0, 10, 10));
        TextureAtlasSprite whiteTexture = VoltaicClientRegister.whiteSprite();
        float u0White = whiteTexture.m_118409_();
        float u1White = whiteTexture.m_118410_();
        float v0White = whiteTexture.m_118411_();
        float v1White = whiteTexture.m_118412_();
        VertexConsumer armBuilder = buffer.m_6299_(Sheets.m_110789_());
        stack.m_85836_();
        stack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        this.armsToRender.forEach((pos, data) -> {
            data.lightParts().forEach(pair -> {
                AABB aabb;
                PrecisionVector vec = (PrecisionVector)pair.getFirst();
                if (!frustum.m_113029_(vec.shiftWhole(aabb = vec.shiftRemainder((AABB)pair.getSecond())))) {
                    return;
                }
                stack.m_85836_();
                stack.m_252880_((float)vec.x, (float)vec.y, (float)vec.z);
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)armBuilder, (AABB)aabb, (float)colorFrame.rFloat(), (float)colorFrame.gFloat(), (float)colorFrame.bFloat(), (float)colorFrame.aFloat(), (float)u0Frame, (float)v0Frame, (float)u1Frame, (float)v1Frame, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            });
            data.darkParts().forEach(pair -> {
                AABB aabb;
                PrecisionVector vec = (PrecisionVector)pair.getFirst();
                if (!frustum.m_113029_(vec.shiftWhole(aabb = vec.shiftRemainder((AABB)pair.getSecond())))) {
                    return;
                }
                stack.m_85836_();
                stack.m_252880_((float)vec.x, (float)vec.y, (float)vec.z);
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)armBuilder, (AABB)aabb, (float)colorFrameDark.rFloat(), (float)colorFrameDark.gFloat(), (float)colorFrameDark.bFloat(), (float)colorFrameDark.aFloat(), (float)u0FrameDark, (float)v0FrameDark, (float)u1FrameDark, (float)v1FrameDark, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            });
            data.titaniumParts().forEach(pair -> {
                AABB aabb;
                PrecisionVector vec = (PrecisionVector)pair.getFirst();
                if (!frustum.m_113029_(vec.shiftWhole(aabb = vec.shiftRemainder((AABB)pair.getSecond())))) {
                    return;
                }
                stack.m_85836_();
                stack.m_252880_((float)vec.x, (float)vec.y, (float)vec.z);
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)armBuilder, (AABB)aabb, (float)colorTitanium.rFloat(), (float)colorTitanium.gFloat(), (float)colorTitanium.bFloat(), (float)colorTitanium.aFloat(), (float)u0Titanium, (float)v0Titanium, (float)u1Titanium, (float)v1Titanium, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            });
            if (data.headType() != null) {
                AABB aabb;
                PrecisionVector vec = (PrecisionVector)data.drillHead().getFirst();
                if (!frustum.m_113029_(vec.shiftWhole(aabb = vec.shiftRemainder((AABB)data.drillHead().getSecond())))) {
                    return;
                }
                TextureAtlasSprite headText = (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(data.headType().blockTextureLoc);
                float u0Head = headText.m_118409_();
                float u1Head = headText.m_118410_();
                float v0Head = headText.m_118411_();
                float v1Head = headText.m_118412_();
                Color colorHead = new Color(armTexture.getPixelRGBA(0, 10, 10));
                stack.m_85836_();
                stack.m_252880_((float)vec.x, (float)vec.y, (float)vec.z);
                if (data.running()) {
                    float speed = (float)Math.max((double)data.speed(), 5.0);
                    float progress = data.progress();
                    if ((double)speed >= 4.0) {
                        progress = Math.abs(minecraft.f_91073_.m_46467_() % 5L);
                    }
                    float degrees = 360.0f * (progress / speed);
                    stack.m_85837_(vec.remX + 0.5, 0.0, vec.remZ + 0.5);
                    stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)degrees, (float)0.0f));
                    stack.m_85837_(-vec.remX - 0.5, 0.0, -vec.remZ - 0.5);
                }
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)armBuilder, (AABB)aabb, (float)colorHead.rFloat(), (float)colorHead.gFloat(), (float)colorHead.bFloat(), (float)colorHead.aFloat(), (float)u0Head, (float)v0Head, (float)u1Head, (float)v1Head, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            }
        });
        buffer.m_109912_(Sheets.m_110789_());
        this.armsToRender.forEach((pos, data) -> {
            BakedModel wheelStill = Minecraft.m_91087_().m_91304_().getModel(ElectrodynamicsClientRegister.MODEL_QUARRYWHEEL_STILL);
            BakedModel wheelRot = Minecraft.m_91087_().m_91304_().getModel(ElectrodynamicsClientRegister.MODEL_QUARRYWHEEL_ROT);
            stack.m_85836_();
            PrecisionVector vec = data.leftWheel().vector();
            stack.m_85837_(vec.totX(), vec.totY(), vec.totZ());
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)data.leftWheel().yAxisRotation(), (float)0.0f));
            RenderingUtils.renderModel((BakedModel)wheelStill, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0625, 0.0);
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)data.leftWheel().xAxisRotation(), (float)0.0f, (float)data.leftWheel().zAxisRotation()));
            stack.m_85837_(0.0, -0.0625, 0.0);
            RenderingUtils.renderModel((BakedModel)wheelRot, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85849_();
            stack.m_85849_();
            stack.m_85836_();
            vec = data.rightWheel().vector();
            stack.m_85837_(vec.totX(), vec.totY(), vec.totZ());
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)data.rightWheel().yAxisRotation(), (float)0.0f));
            RenderingUtils.renderModel((BakedModel)wheelStill, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0625, 0.0);
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)data.rightWheel().xAxisRotation(), (float)0.0f, (float)data.rightWheel().zAxisRotation()));
            stack.m_85837_(0.0, -0.0625, 0.0);
            RenderingUtils.renderModel((BakedModel)wheelRot, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85849_();
            stack.m_85849_();
            stack.m_85836_();
            vec = data.bottomWheel().vector();
            stack.m_85837_(vec.totX(), vec.totY(), vec.totZ());
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)data.bottomWheel().yAxisRotation(), (float)0.0f));
            RenderingUtils.renderModel((BakedModel)wheelStill, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0625, 0.0);
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)data.bottomWheel().xAxisRotation(), (float)0.0f, (float)data.bottomWheel().zAxisRotation()));
            stack.m_85837_(0.0, -0.0625, 0.0);
            RenderingUtils.renderModel((BakedModel)wheelRot, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85849_();
            stack.m_85849_();
            stack.m_85836_();
            vec = data.topWheel().vector();
            stack.m_85837_(vec.totX(), vec.totY(), vec.totZ());
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)data.topWheel().yAxisRotation(), (float)0.0f));
            RenderingUtils.renderModel((BakedModel)wheelStill, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0625, 0.0);
            stack.m_252781_(MathUtils.rotQuaternionDeg((float)data.topWheel().xAxisRotation(), (float)0.0f, (float)data.topWheel().zAxisRotation()));
            stack.m_85837_(0.0, -0.0625, 0.0);
            RenderingUtils.renderModel((BakedModel)wheelRot, null, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)buffer, (int)LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)new BlockPos(vec.x, vec.y, vec.z)), (int)OverlayTexture.f_118083_);
            stack.m_85849_();
            stack.m_85849_();
        });
        VertexConsumer lineBuilder = buffer.m_6299_(Sheets.m_110792_());
        this.armsToRender.forEach((pos, data) -> {
            BlockPos start = data.corners().get(0);
            BlockPos nearCorner = data.corners().get(1);
            BlockPos farCorner = data.corners().get(2);
            BlockPos end = data.corners().get(3);
            int time = 200;
            int cutoff = 180;
            int half = (time - cutoff) / 2;
            float alpha = minecraft.f_91073_.m_46467_() % (long)time;
            if (alpha < (float)cutoff) {
                return;
            }
            if ((alpha = (float)time - alpha) <= (float)half) {
                alpha /= (float)half;
            } else {
                alpha -= (float)half;
                alpha = 1.0f - alpha / (float)half;
            }
            double deltaX = nearCorner.m_123341_() - start.m_123341_();
            double deltaZ = nearCorner.m_123343_() - start.m_123343_();
            AABB beam = new AABB(0.4375, 0.5625, 0.4375, deltaX * (double)data.signs()[0] + 0.5625, 0.6875, deltaZ * (double)data.signs()[0] + 0.5625);
            if (frustum.m_113029_(beam.m_82338_(start))) {
                stack.m_85836_();
                stack.m_252880_((float)start.m_123341_(), (float)start.m_123342_(), (float)start.m_123343_());
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)lineBuilder, (AABB)beam, (float)1.0f, (float)0.0f, (float)0.0f, (float)alpha, (float)u0White, (float)v0White, (float)u1White, (float)v1White, (int)255, (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            }
            deltaX = farCorner.m_123341_() - start.m_123341_();
            deltaZ = farCorner.m_123343_() - start.m_123343_();
            beam = new AABB(0.4375, 0.5625, 0.4375, deltaX * (double)data.signs()[1] + 0.5625, 0.6875, deltaZ * (double)data.signs()[1] + 0.5625);
            if (frustum.m_113029_(beam.m_82338_(start))) {
                stack.m_85836_();
                stack.m_252880_((float)start.m_123341_(), (float)start.m_123342_(), (float)start.m_123343_());
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)lineBuilder, (AABB)beam, (float)1.0f, (float)0.0f, (float)0.0f, (float)alpha, (float)u0White, (float)v0White, (float)u1White, (float)v1White, (int)255, (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            }
            deltaX = end.m_123341_() - nearCorner.m_123341_();
            deltaZ = end.m_123343_() - nearCorner.m_123343_();
            beam = new AABB(0.4375, 0.5625, 0.4375, deltaX * (double)data.signs()[2] + 0.5625, 0.6875, deltaZ * (double)data.signs()[2] + 0.5625);
            if (frustum.m_113029_(beam.m_82338_(end))) {
                stack.m_85836_();
                stack.m_252880_((float)end.m_123341_(), (float)end.m_123342_(), (float)end.m_123343_());
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)lineBuilder, (AABB)beam, (float)1.0f, (float)0.0f, (float)0.0f, (float)alpha, (float)u0White, (float)v0White, (float)u1White, (float)v1White, (int)255, (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            }
            deltaX = end.m_123341_() - farCorner.m_123341_();
            deltaZ = end.m_123343_() - farCorner.m_123343_();
            beam = new AABB(0.4375, 0.5625, 0.4375, deltaX * (double)data.signs()[3] + 0.5625, 0.6875, deltaZ * (double)data.signs()[3] + 0.5625);
            if (frustum.m_113029_(beam.m_82338_(end))) {
                stack.m_85836_();
                stack.m_252880_((float)end.m_123341_(), (float)end.m_123342_(), (float)end.m_123343_());
                RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)lineBuilder, (AABB)beam, (float)1.0f, (float)0.0f, (float)0.0f, (float)alpha, (float)u0White, (float)v0White, (float)u1White, (float)v1White, (int)255, (boolean[])RenderingUtils.ALL_FACES);
                stack.m_85849_();
            }
        });
        buffer.m_109912_(Sheets.m_110792_());
        stack.m_85849_();
    }

    public void clear() {
        this.armsToRender.clear();
    }

    public static void addRenderData(BlockPos pos, QuarryArmDataHolder data) {
        HandlerQuarryArm.INSTANCE.armsToRender.put(pos, data);
    }

    public static void removeRenderData(BlockPos pos) {
        HandlerQuarryArm.INSTANCE.armsToRender.remove(pos);
    }
}

