/*
 * Decompiled with CFR 0.152.
 */
package dynamicelectricity.datagen;

import dynamicelectricity.datagen.client.DynamicElectricityBlockStateProvider;
import dynamicelectricity.datagen.client.DynamicElectricityItemModelsProvider;
import dynamicelectricity.datagen.client.DynamicElectricityLangKeyProvider;
import dynamicelectricity.datagen.client.DynamicElectricitySoundProvider;
import dynamicelectricity.datagen.server.DynamicElectricityLootTablesProvider;
import dynamicelectricity.datagen.server.recipe.DynamicElectricityRecipeProvider;
import dynamicelectricity.datagen.server.tags.DynamicElectricityTagsProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.datagen.utils.client.BaseLangKeyProvider;

@Mod.EventBusSubscriber(modid="dynamicelectricity", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(DynamicElectricityLootTablesProvider::new, LootContextParamSets.f_81421_))));
            generator.addProvider(true, (DataProvider)new DynamicElectricityRecipeProvider(output));
            DynamicElectricityTagsProvider.addTagProviders(generator, output, lookupProvider, helper);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new DynamicElectricityBlockStateProvider(output, helper));
            generator.addProvider(true, (DataProvider)new DynamicElectricityItemModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new DynamicElectricityLangKeyProvider(output, BaseLangKeyProvider.Locale.EN_US));
            generator.addProvider(true, (DataProvider)new DynamicElectricitySoundProvider(output, helper));
        }
    }
}

